<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class RiderLocationUpdated implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $riderId;
    public $latitude;
    public $longitude;

    public function __construct($riderId, $latitude, $longitude)
    {
        $this->riderId = $riderId;
        $this->latitude = $latitude;
        $this->longitude = $longitude;
    }

    public function broadcastOn()
    {
        return new Channel('rider-tracking.' . $this->riderId);
    }

    public function broadcastAs()
    {
        return 'location.updated';
    }

    public function broadcastWith()
    {
        // This ensures your event sends the data over Reverb
        return [
            'rider_id'  => $this->riderId,
            'latitude'  => $this->latitude,
            'longitude' => $this->longitude,
        ];
    }
}
