<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Warehouse;
use Illuminate\Http\Request;
use Kreait\Firebase\Factory;
use App\Models\User;

class AuthController extends Controller
{
    public function firebaseLogin(Request $request)
    {
        $request->validate([
            'token' => 'required'
        ]);

        $factory = (new Factory)
            ->withServiceAccount(storage_path('firebase.json'));

        $auth = $factory->createAuth();

        try {
            $verifiedIdToken = $auth->verifyIdToken($request->token);

            $uid   = $verifiedIdToken->claims()->get('sub');
            $phone = $verifiedIdToken->claims()->get('phone_number');

            // create or get user
            $user = Warehouse::firstOrCreate(
                ['mobile_number' => $phone],
                ['firebase_uid' => $uid]
            );

            // create api token (Laravel Sanctum)
            $apiToken = $user->createToken('mobile-app')->plainTextToken;

            return response()->json([
                'success' => true,
                'user' => $user,
                'token' => $apiToken
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Invalid Firebase token'
            ], 401);
        }
    }
}
