<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CustomerOtpMail extends Mailable
{
    use Queueable, SerializesModels;

    public $otp;
    public $customerName;

    /**
     * Create a new message instance.
     *
     * @param string $otp
     */
    public function __construct($otp, $customerName)
    {
        $this->otp = $otp;
        $this->customerName = $customerName;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Your OTP for Login')
                    ->view('emails.customer-otp')
                    ->with([
                        'otp' => $this->otp,
                        'customerName' => $this->customerName
                    ]);
    }
}
