<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderDeliveredMail extends Mailable
{
    use Queueable, SerializesModels;

    public $order;
    public $user;
    public $isSeller;

    public function __construct($order, $user, $isSeller = false)
    {
        $this->order = $order;
        $this->user = $user;
        $this->isSeller = $isSeller;
    }

    public function build()
    {
        return $this->subject(
                $this->isSeller
                    ? "Order #{$this->order->order_no} Delivered to Customer"
                    : "Your Order #{$this->order->order_no} has been Delivered"
            )
            ->view(
                $this->isSeller
                    ? 'emails.order_delivered_seller'
                    : 'emails.order_delivered_buyer'
            );
    }
}
