<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderTakenMail extends Mailable
{
    use Queueable, SerializesModels;

    public $order;
    public $receiver;
    public $receiverType;

    public function __construct($order, $receiver, $receiverType)
    {
        $this->order        = $order;
        $this->receiver     = $receiver;
        $this->receiverType = $receiverType;
    }

    public function build()
    {
        return $this->subject("New Order #{$this->order->order_no} Assigned")
            ->view('emails.order_taken');
    }
}
