<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BankBranch extends Model
{
    use HasFactory;

    protected $table = 'bank_branches';

    protected $primaryKey = 'id';

    public $incrementing = true;

    protected $keyType = 'int';

    public $timestamps = true;

    protected $fillable = [
        'bank',
        'ifsc',
        'branch',
        'micr',
        'address',
        'state',
        'city',
        'district',
        'centre',
        'contact',
        'upi',
        'rtgs',
        'neft',
        'imps',
        'swift',
        'iso3166',
    ];

    protected $casts = [
        'upi' => 'boolean',
        'rtgs' => 'boolean',
        'neft' => 'boolean',
        'imps' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];
}
