<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class Customer extends Authenticatable implements JWTSubject
{
    protected $fillable = [
        'name','email','mobile_number','password', 'profile_image',
        'door_no','street_name','area','city','district',
        'state','pincode','country',
        'status','otp','otp_created_at'
    ];

    protected $hidden = ['password','otp'];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }

    public function fcmTokens()
    {
        return $this->hasMany(FcmToken::class, 'user_id')
            ->where('user_type', 'customer');
    }
}
