<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Category;
use App\Models\Subcategory;
use App\Models\Brand;

class Product extends Model
{
    use HasFactory;

    protected $table = 'products';

    /**
     * Mass assignable fields
     */
    protected $fillable = [
        'category',
        'subcategory',
        'brand',
        'quantity_unit',

        'category_id',
        'subcategory_id',
        'brand_id',
        'quantity_unit_id',

        'image',
        'colors',
        'description',

        'store_price',
        'store_discount_type',
        'store_discount_value',
        'store_price_assigned_by',
        'store_price_assigned_at',

        'customer_price',
        'customer_discount_type',
        'customer_discount_value',
        'customer_price_assigned_by',
        'customer_price_assigned_at',

        'status',
    ];


    /**
     * Casts
     */
    protected $casts = [
        'store_price' => 'decimal:2',
        'store_discount_value' => 'decimal:2',
        'customer_price' => 'decimal:2',
        'customer_discount_value' => 'decimal:2',
        'store_price_assigned_at' => 'datetime',
        'customer_price_assigned_at' => 'datetime',
        'colors' => 'array',
    ];


    /* =======================
     | Relationships
     ======================= */

    /**
     * Warehouses selling this product
     */
    public function warehouseProducts()
    {
        return $this->hasMany(WarehouseProduct::class, 'product_id');
    }

    /**
     * Stores selling this product
     */
    public function storeProducts()
    {
        return $this->hasMany(StoreProduct::class, 'product_id');
    }

    /**
     * Admin who assigned store price
     */
    public function storePriceAssignedBy()
    {
        return $this->belongsTo(Admin::class, 'store_price_assigned_by');
    }

    /**
     * Admin who assigned customer price
     */
    public function customerPriceAssignedBy()
    {
        return $this->belongsTo(Admin::class, 'customer_price_assigned_by');
    }
    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function subcategory()
    {
        return $this->belongsTo(Subcategory::class, 'subcategory_id');
    }

    public function quantityUnit()
    {
        return $this->belongsTo(QuantityUnit::class, 'quantity_unit_id');
    }


    public function brand()
    {
        return $this->belongsTo(Brand::class, 'brand_id');
    }
    public function reviews()
    {
        return $this->hasMany(ProductReview::class);
    }

}
