<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuantityUnit extends Model
{
    use HasFactory;

    protected $table = 'quantity_units';

    protected $fillable = ['name', 'category_ids', 'status'];

    protected $casts = [
        'category_ids' => 'array',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }
}
