<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class Rider extends Authenticatable implements JWTSubject
{
    protected $table = 'riders';

    protected $fillable = [
        'rider_code',
        'name','email','mobile_number','password',

        'door_no','street_name','area','city',
        'state_id','district_id','pincode','country',
        'latitude','longitude',

        'logo',
        'vehicle_type','vehicle_number',
        'driving_license_no','rc_book_no',

        'pan_number','aadhar_number',

        'bank_id','bank_holder_name','bank_account_number',
        'ifsc_code','micr_no','upi_id',
        'bank_status','bank_approved_at','bank_approved_by',
        'bank_edit_reason','edit_bank',
        'passbook_file',
        'pending_bank_data',

        'ratePerKm',
        'range',
        'rate_change_status',
        'rate_approved_at',
        'rate_approved_by',

        'otp','otp_created_at',
        'status','admin_remark',
        'approved_at','approved_by',

        'work_status',
        'is_available',
    ];

    protected $casts = [
        'edit_bank' => 'boolean',
        'work_status' => 'boolean',
        'is_available' => 'boolean',

        'ratePerKm' => 'decimal:2',
        'range' => 'decimal:2',

        'bank_approved_at' => 'datetime',
        'rate_approved_at' => 'datetime',
        'approved_at' => 'datetime',
        'otp_created_at' => 'datetime',

        'pending_bank_data' => 'array',

    ];



    protected $hidden = [
        'password',
        'otp'
    ];


    // 🔑 REQUIRED BY JWT
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }


    public function state()
    {
        return $this->belongsTo(State::class, 'state_id');
    }

    public function district()
    {
        return $this->belongsTo(District::class, 'district_id');
    }

    public function bank()
    {
        return $this->belongsTo(Bank::class, 'bank_id');
    }

    public function locations()
    {
        return $this->hasMany(RiderLocation::class, 'rider_id');
    }

    public function latestLocation()
    {
        return $this->hasOne(RiderLocation::class, 'rider_id')->latest();
    }

    public function fcmTokens()
    {
        return $this->hasMany(FcmToken::class, 'user_id')
            ->where('user_type', 'rider');
    }

}
