<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Tymon\JWTAuth\Contracts\JWTSubject;

class Store extends Authenticatable implements JWTSubject
{
    use HasFactory;

    protected $fillable = [
        'owner_name',
        'email',
        'mobile_number',
        'store_name',  
        'password',
        'door_no',
        'street_name',
        'area',
        'city',
        'district_id',
        'state_id',
        'pincode',
        'country',
        'gst_number',
        'pan_number',
        'aadhar_number',
        'business_type',
        'business_status',
        'trade_license_number',
        'bank_id',
        'bank_holder_name',
        'bank_account_number',
        'ifsc_code',
        'micr_no',
        'upi_id',
        'passbook_file',
        'bank_status',
        'bank_approved_at', 
        'bank_approved_by',
        'edit_bank',
        'bank_edit_reason',
        'pending_bank_data',
        'status',
        'logo',
        'admin_remark',
        'approved_at',
        'approved_by',
        'otp',
        'otp_created_at',
        'latitude',
        'longitude',
        'registration_paid',
        'registration_payment_id',
        'store_type'
    ];



    protected $hidden = [
        'password',
        'otp'
    ];

    protected $casts = [
        'pending_bank_data' => 'array',
    ];


    public function products()
    {
        return $this->hasMany(StoreProduct::class);
    }

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }
    public function state()
    {
        return $this->belongsTo(State::class, 'state_id');
    }

    public function district()
    {
        return $this->belongsTo(District::class, 'district_id');
    }

    public function bank()
    {
        return $this->belongsTo(Bank::class, 'bank_id');
    }

    public function fcmTokens()
    {
        return $this->hasMany(FcmToken::class, 'user_id')
            ->where('user_type', 'store');
    }
}
