<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\State;
use App\Models\District;

class StateDistrictSeeder extends Seeder
{
    public function run()
    {
        $json = file_get_contents(storage_path('app/states-and-districts.json'));
        $data = json_decode($json, true);

        foreach ($data['states'] as $stateData) {
            $state = State::create(['name' => $stateData['state']]);
            foreach ($stateData['districts'] as $districtName) {
                District::create([
                    'state_id' => $state->id,
                    'name' => $districtName
                ]);
            }
        }
    }
}
