<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    <style>
        body {
            min-height: 100vh;
            background: linear-gradient(135deg, #29B2F6, #5AF399);
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', sans-serif;
        }

        .login-card {
            width: 100%;
            max-width: 420px;
            background: #fff;
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 10px 40px rgba(0,0,0,0.15);
        }

        .login-logo {
            text-align: center;
            margin-bottom: 1.5rem;
        }

        .login-logo img {
            max-height: 70px;
        }

        .login-title {
            font-weight: 600;
            text-align: center;
            margin-bottom: 1.5rem;
            color: #0f172a;
        }

        .form-control {
            border-radius: 10px;
            padding: 0.7rem 0.75rem;
        }

        .form-control:focus {
            border-color: #29B2F6;
            box-shadow: 0 0 0 0.2rem rgba(41,178,246,.25);
        }

        .btn-login {
            background: linear-gradient(135deg, #29B2F6, #5AF399);
            border: none;
            border-radius: 10px;
            padding: 0.7rem;
            font-weight: 600;
            color: #fff;
            transition: 0.3s;
        }

        .btn-login:hover {
            opacity: 0.9;
            transform: translateY(-1px);
        }

        .footer-text {
            text-align: center;
            font-size: 0.85rem;
            color: #64748b;
            margin-top: 1rem;
        }
    </style>
</head>
<body>

    <div class="login-card">

        <!-- Logo -->
        <div class="login-logo">
            <img src="{{ asset('assets/images/logo.jpg') }}" alt="Admin Logo">
        </div>

        <h5 class="login-title">Admin Login</h5>

        <!-- Error Message -->
        @if(session('error'))
            <div class="alert alert-danger text-center">
                {{ session('error') }}
            </div>
        @endif

        <!-- Login Form -->
        <form method="POST" action="{{ route('admin.login.submit') }}">
            @csrf

            <div class="mb-3">
                <label class="form-label">Email</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fa fa-envelope"></i></span>
                    <input type="email" name="email" class="form-control" required autofocus>
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label">Password</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fa fa-lock"></i></span>
                    <input type="password" name="password" class="form-control" required>
                </div>
            </div>

            <button type="submit" class="btn btn-login w-100">
                <i class="fa fa-sign-in-alt me-1"></i> Login
            </button>
        </form>

        <div class="footer-text">
            © {{ date('Y') }} Admin Panel
        </div>
    </div>

</body>
</html>
