@extends('admin.layouts.app')

@section('title', 'Order Details')

@section('styles')
<style>
/* ===============================
   DETAIL PAGE STYLING
=============================== */
.card {
    border: none;
    border-radius: 12px;
    box-shadow: 0 8px 20px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
}
.card-header {
    background: linear-gradient(to bottom, #29B2F6, #5AF399);
    color: #fff;
    font-weight: 600;
    font-size: 1.1rem;
    border-top-left-radius: 12px;
    border-top-right-radius: 12px;
}
.detail-row {
    margin-bottom: 1rem;
}
.detail-label {
    font-weight: 600;
    color: #374151;
}
.detail-value {
    color: #111827;
}
.status-badge {
    padding: 6px 16px;
    border-radius: 30px;
    font-weight: 600;
    font-size: 0.9rem;
}
.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-pending { background: #fff5e5; color: #d48806; }
.status-rejected { background: #fdecea; color: #c62828; }

.btn-back {
    background: #f0f4f8;
    color: #10171d;
    font-weight: 500;
    border-radius: 8px;
}
.action-btn {
    padding: 10px 24px;
    border-radius: 8px;
    font-weight: 600;
    margin-right: 12px;
    border: none;
}
.action-approve { background: #22c55e; color: #fff; }
.action-reject { background: #ef4444; color: #fff; }
.modal-header {
    background: linear-gradient(to bottom, #29B2F6, #5AF399);
    color: #fff;
}

.modal-dialog {
    margin-left: auto !important;
    margin-right: auto !important;
    justify-content: center !important;
}

.modal {
    padding-right: 0 !important;
}

th{
    text-align: center;
}

.info-grid{
    display:grid;
    grid-template-columns: repeat(2,1fr);
    gap:12px;
}
.info-grid div{
    background:#f8f9fa;
    padding:10px 12px;
    border-radius:8px;
}
.info-grid span{
    font-size:12px;
    color:#6c757d;
    display:block;
}
.info-grid p{
    margin:0;
    font-weight:600;
}
.info-grid .full{
    grid-column:1/3;
}

.order-timeline{
    list-style:none;
    padding:0;
    margin:0;
}
.order-timeline li{
    padding:8px 0;
    border-bottom:1px dashed #ddd;
    font-weight:500;
}

.status-badge{
    padding:4px 10px;
    border-radius:20px;
    font-size:12px;
    font-weight:600;
}

/* Horizontal Timeline Styles */
.timeline-horizontal {
    position: relative;
    gap: 0;
}
.timeline-step {
    position: relative;
    text-align: center;
    padding: 0 5px;
}
.timeline-icon {
    width: 40px;
    height: 40px;
    line-height: 40px;
    font-size: 1.2rem;
}
.timeline-label {
    margin-bottom: 0.25rem;
}
.timeline-date, .timeline-time {
    font-size: 0.85rem;
}
.timeline-connector {
    height: 4px;
    width: 100%;
    background-color: #ccc;
    position: absolute;
    top: 50%;
    left: 100%;
    z-index: -1;
}
.timeline-step:last-child .timeline-connector {
    display: none;
}

.hover-card {
    transition: transform 0.2s, box-shadow 0.2s;
    cursor: pointer;
}
.hover-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.15);
}
.info-grid div {
    margin-bottom: 0.5rem;
}
.info-grid span {
    font-weight: 500;
    color: #555;
}
.info-grid p {
    margin: 0;
    font-weight: 600;
}
.bill-row{
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:6px 0;
    font-size:15px;
}

.bill-row span:first-child{
    color:#555;
}

.bill-divider{
    border-top:1px dashed #ddd;
    margin:10px 0;
}

.bill-total{
    font-size:17px;
    font-weight:700;
}

.bill-total span:last-child{
    color:#0d6efd;
}



</style>
@endsection



@section('content')
<div class="container-fluid">

    <!-- HEADER -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-semibold mb-1">Order #{{ $order->order_no }}</h4>
            <span class="status-badge status-{{ $order->status }}">
                {{ ucwords(str_replace('_',' ', $order->status)) }}
            </span>
        </div>
        <a href="{{ route('admin.orders.index') }}" class="btn btn-back btn-sm">
            ← Back to Orders
        </a>
    </div>

    <!-- ================= ROW 1 ================= -->
    <div class="row g-3">
        <!-- ORDER INFO -->
        <div class="col-md-6">
            <div class="card h-100">
                <div class="card-header">Order Info</div>
                <div class="card-body info-grid">
                    <div><span>Order No</span><p>{{ $order->order_no }}</p></div>
                    <div><span>Invoice No</span><p>{{ $order->invoice_no ?? 'N/A' }}</p></div>
                    <div><span>With Shipping</span><p>{{ $order->with_shipping ? 'Yes' : 'No' }}</p></div>
                    <div><span>Created At</span><p>{{ $order->created_at }}</p></div>
                </div>
            </div>
        </div>

        <!-- PAYMENT INFO -->
        <div class="col-md-6">
            <div class="card h-100">
                <div class="card-header">Payment Info</div>
                <div class="card-body info-grid">
                    <div><span>Method</span><p>{{ $order->payment_method ?? 'N/A' }}</p></div>
                    <div><span>Status</span><p>{{ ucfirst($order->payment_status) }}</p></div>
                    <div><span>Paid At</span><p>{{ $order->paid_at ?? 'Not Paid' }}</p></div>
                    <div><span>Failed At</span><p>{{ $order->failed_at ?? 'N/A' }}</p></div>
                </div>
            </div>
        </div>
    </div>

    <!-- ================= USER CARDS ================= -->
    <div class="row g-3 mt-1">

        <!-- SELLER -->
        <div class="col-md-4">
            @if($order->approved_by)
                @php
                    $sellerRoute = $order->approved_by_user_type === 'warehouse' 
                        ? route('admin.users.show', ['type' => 'warehouse', 'id' => $order->approved_by])
                        : route('admin.users.show', ['type' => 'store', 'id' => $order->approved_by]);
                @endphp
                <a href="{{ $sellerRoute }}" class="text-decoration-none">
                    <div class="card h-85 shadow-sm hover-card">
                        <div class="card-header bg-success text-white">Seller</div>
                        <div class="card-body info-grid">
                            <div><span>Name</span><p>{{ $order->sellerName() ?? 'N/A' }}</p></div>
                            <div><span>Type</span><p>{{ $order->approved_by_user_type ?? 'N/A' }}</p></div>
                        </div>
                    </div>
                </a>
            @else
                <div class="card h-85 shadow-sm">
                    <div class="card-header bg-success text-white">Seller</div>
                    <div class="card-body text-muted text-center">Not Assigned</div>
                </div>
            @endif
        </div>

        <!-- BUYER -->
        <div class="col-md-4">
            @if($order->user_id)
                <a href="{{ $order->user_type === 'customer' 
                    ? route('admin.users.show', ['type' => 'customer', 'id' => $order->user_id])
                    : route('admin.users.show', ['type' => 'store', 'id' => $order->user_id]) }}" 
                    class="text-decoration-none">
                    <div class="card h-85 shadow-sm hover-card">
                        <div class="card-header bg-info text-white">Buyer</div>
                        <div class="card-body info-grid">
                            <div><span>Name</span><p>{{ $order->buyerName() }}</p></div>
                            <div><span>Type</span><p>{{ ucfirst($order->user_type) }}</p></div>
                        </div>
                    </div>
                </a>
            @else
                <div class="card h-85 shadow-sm">
                    <div class="card-header bg-info text-white">Buyer</div>
                    <div class="card-body text-muted text-center">Not Assigned</div>
                </div>
            @endif
        </div>

        <!-- RIDER -->
        <div class="col-md-4">
            @if($order->rider)
                <a href="{{ route('admin.riders.show', $order->rider->id) }}" class="text-decoration-none">
                    <div class="card h-85 shadow-sm hover-card">
                        <div class="card-header bg-success text-white">Rider</div>
                        <div class="card-body info-grid">
                            <div><span>Name</span><p>{{ $order->rider->name }}</p></div>
                            <div><span>Rider Code</span><p>{{ $order->rider->rider_code }}</p></div>
                        </div>
                    </div>
                </a>
            @else
                <div class="card h-85 shadow-sm">
                    <div class="card-header bg-success text-white">Rider</div>
                    <div class="card-body text-muted text-center">
                        Not Assigned
                    </div>
                </div>
            @endif
        </div>
    </div>

    
    <!-- ================= HORIZONTAL TIMELINE ================= -->
    <div class="card mt-3 shadow-sm">
        <div class="card-header bg-primary text-white">Order Timeline</div>
        <div class="card-body">
            <div class="timeline-horizontal d-flex justify-content-between align-items-center position-relative">

                @php
                    $stages = [
                        ['label' => 'Created', 'icon' => '🟢', 'time' => $order->created_at],
                        ['label' => 'Approved', 'icon' => '🟡', 'time' => $order->approved_at],
                        ['label' => 'Loaded', 'icon' => '📦', 'time' => $order->loaded_at],
                        ['label' => 'In Transit', 'icon' => '🚚', 'time' => $order->ride_started_at],
                        ['label' => 'Delivered', 'icon' => '✅', 'time' => $order->delivered_at],
                    ];
                @endphp

                @foreach($stages as $stage)
                    <div class="timeline-step text-center flex-fill position-relative">
                        <!-- Icon Circle -->
                        <div class="timeline-icon bg-primary text-white rounded-circle mx-auto mb-2">
                            {{ $stage['icon'] }}
                        </div>
                        <!-- Label -->
                        <div class="timeline-label fw-bold">{{ $stage['label'] }}</div>
                        <!-- Date & Time -->
                        @if($stage['time'])
                            <div class="timeline-date text-secondary">
                                {{ \Carbon\Carbon::parse($stage['time'])->format('d/m/Y') }}
                            </div>
                            <div class="timeline-time text-muted">
                                {{ \Carbon\Carbon::parse($stage['time'])->format('h:i A') }}
                            </div>
                        @else
                            <div class="timeline-date text-muted">Pending</div>
                            <div class="timeline-time text-muted">--:--</div>
                        @endif
                        <!-- Connector Line -->
                        @if(!$loop->last)
                            <div class="timeline-connector position-absolute top-50 start-100 translate-middle-y"></div>
                        @endif
                    </div>
                @endforeach

            </div>
        </div>
    </div>

    <!-- ================= ORDER ITEMS ================= -->
    <div class="card mt-3">
        <div class="card-header text-center">Order Items</div>

        <div class="card-body table-responsive">
            <table class="table table-hover align-middle text-center">
                <thead class="text-center">
                    <tr>
                        <th>#</th>
                        <th>Image</th>
                        <th>Product</th>
                        <th>Unit</th>
                        <th>Qty</th>
                        <th>Unit Price</th>
                        <th>Discount</th>
                        <th>Total</th>
                        <th>Status</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach($order->items as $i => $item)
                    <tr>
                        <td>{{ $i+1 }}</td>

                        <!-- Image -->
                        <td>
                            <img src="{{ asset('storage/'.$item->product->image) }}"
                                onerror="this.src='https://via.placeholder.com/40'"
                                style="width:40px;height:40px;object-fit:cover;border-radius:6px;border:1px solid #ddd;">
                        </td>

                        <!-- Category -->
                        <td>
                            {{ $item->product->subcategory ?? '-' }}<br>
                            <small>{{ $item->product->category ?? '-' }}</small>
                        </td>

                        <!-- Unit -->
                        <td>
                            {{ $item->product->quantity_unit ?? '-' }}
                        </td>

                        <!-- Qty -->
                        <td>
                            {{ $item->quantity }}
                        </td>

                        <!-- Unit Price -->
                        <td>
                            ₹{{ number_format($item->unit_price,2) }}
                        </td>

                        <!-- Discount -->
                        <td>
                            @if($item->discount_amount > 0)
                                <span class="text-danger fw-semibold">
                                    -₹{{ number_format($item->discount_amount,2) }}
                                </span>
                            @else
                                —
                            @endif
                        </td>

                        <!-- Total -->
                        <td class="fw-semibold">
                            ₹{{ number_format($item->total_price,2) }}
                        </td>

                        <!-- Status -->
                        <td>
                            <span class="badge bg-light text-dark border">
                                {{ ucfirst($item->status) }}
                            </span>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- ================= RIDER REQUESTS ================= -->
    <div class="card mt-3">
        <div class="card-header">Rider Requests</div>
        <div class="card-body table-responsive">
            <table class="table table-hover align-middle text-center">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Rider</th>
                        <th>Status</th>
                        <th>Distance</th>
                        <th>Trip Amount</th>
                        <th>Requested At</th>
                        <th>Responded At</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($order->riderRequests as $i => $req)
                    <tr>
                        <td>{{ $i+1 }}</td>

                        <!-- Rider Name + Code -->
                        <td>
                            <strong>{{ $req->rider->name ?? 'N/A' }}</strong><br>
                            <small class="text-muted">{{ $req->rider->rider_code ?? '' }}</small><br>
                            <small class="text-muted">{{ $req->rider->mobile_number ?? '' }}</small>
                        </td>

                        <!-- Status -->
                        <td>
                            <span class="badge bg-{{ $req->status == 'accepted' ? 'success' : ($req->status == 'rejected' ? 'danger' : 'secondary') }}">
                                {{ ucfirst($req->status) }}
                            </span>
                        </td>

                        <!-- Distance -->
                        <td>{{ $req->distance_km ?? '0' }} km</td>

                        <!-- Trip Amount -->
                        <td>₹{{ number_format($req->trip_amount ?? 0, 2) }}</td>

                        <!-- Requested At -->
                        <td>
                            @if($req->requested_at)
                                {{ \Carbon\Carbon::parse($req->requested_at)->format('d/m/Y') }}<br>
                                <small>{{ \Carbon\Carbon::parse($req->requested_at)->format('h:i A') }}</small>
                            @else
                                N/A
                            @endif
                        </td>

                        <!-- Responded At -->
                        <td>
                            @if($req->responded_at)
                                {{ \Carbon\Carbon::parse($req->responded_at)->format('d/m/Y') }}<br>
                                <small>{{ \Carbon\Carbon::parse($req->responded_at)->format('h:i A') }}</small>
                            @else
                                N/A
                            @endif
                        </td>

                        <!-- Action Button -->
                        <td>
                            @if($req->rider)
                                <a href="{{ route('admin.riders.show', $req->rider->id) }}" class="btn btn-sm btn-primary">
                                    View
                                </a>
                            @else
                                <span class="text-muted">N/A</span>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center text-muted">No rider requests</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>



    <!-- ================= SUMMARY ================= -->
    <div class="row g-3 mt-1">

        <div class="col-md-6">
            <div class="card h-100 shadow-sm">
                <div class="card-header">Payment Summary</div>

                <!-- Bill Style Body -->
                <div class="card-body p-3">

                    <div class="bill-row">
                        <span>Items Total</span>
                        <span>₹{{ number_format($order->items_total,2) }}</span>
                    </div>

                    <div class="bill-row">
                        <span>Discount</span>
                        <span class="text-success">- ₹{{ number_format($order->discount_amount,2) }}</span>
                    </div>

                    <div class="bill-row">
                        <span>Delivery Fee</span>
                        <span>₹{{ number_format($order->delivery_fee,2) }}</span>
                    </div>

                    <div class="bill-divider"></div>

                    <div class="bill-row bill-total">
                        <span>Grand Total</span>
                        <span>₹{{ number_format($order->grand_total,2) }}</span>
                    </div>

                </div>
            </div>
        </div>


        <!-- ADDRESS -->
        <div class="col-md-6">
            <div class="card h-100">
                <div class="card-header">Delivery Address</div>
                <div class="card-body">
                    @if($order->shippingAddress)
                        <div class="address-box">
                            <!-- Name & Mobile -->
                            <div class="row mb-2">
                                <div class="col-6 fw-semibold">Name</div>
                                <div class="col-6">{{ $order->shippingAddress->name ?? 'Customer' }}</div>
                            </div>
                            <div class="row mb-2">
                                <div class="col-6 fw-semibold">Mobile</div>
                                <div class="col-6">{{ $order->shippingAddress->mobile_number }}</div>
                            </div>

                            <!-- Address -->
                            <div class="row mb-2">
                                <div class="col-6 fw-semibold">Address</div>
                                <div class="col-6">
                                    {{ $order->shippingAddress->door_no ?? '' }}
                                    {{ $order->shippingAddress->street_name ? ', '.$order->shippingAddress->street_name : '' }}
                                    {{ $order->shippingAddress->area ? ', '.$order->shippingAddress->area : '' }}
                                </div>
                            </div>

                            <!-- City / District / State -->
                            <div class="row mb-2">
                                <div class="col-6 fw-semibold">City / District / State</div>
                                <div class="col-6">
                                    {{ $order->shippingAddress->city ?? '' }},
                                    {{ $order->shippingAddress->district->name ?? '' }},
                                    {{ $order->shippingAddress->state->name ?? '' }}
                                </div>
                            </div>

                            <!-- Pincode -->
                            <div class="row">
                                <div class="col-6 fw-semibold">Pincode</div>
                                <div class="col-6">{{ $order->shippingAddress->pincode ?? '' }}</div>
                            </div>
                        </div>
                    @else
                        <span class="text-muted">No shipping address</span>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
