@extends('admin.layouts.app')

@section('title', isset($product) ? 'Edit Product' : 'Add Product')

@section('content')

{{-- ===============================
   FULL STYLE SECTION
=============================== --}}
<style>
/* Card */
.form-card {
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 10px 25px rgba(0,0,0,.08);
}

/* Header */
.form-header {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    padding: 16px 24px;
}

/* Inputs */
.form-control, .form-select {
    border-radius: 10px;
    border: 1px solid #ced4da;
    box-shadow: none;
}

.form-control:focus, .form-select:focus {
    border-color: #29B2F6;
    box-shadow: 0 0 0 3px rgba(41,178,246,.15);
}

/* Labels */
.form-label {
    font-weight: 600;
    font-size: 14px;
    color: #374151;
}

/* Buttons */
.btn-add {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-radius: 22px;
    padding: 10px 26px;
    font-weight: 600;
    border: none;
}

.btn-add:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 15px rgba(41,178,246,.35);
}

.btn-outline-secondary {
    border-radius: 22px;
    padding: 10px 24px;
}

/* Section spacing */
.form-section {
    padding: 24px;
}

/* Error UI */
.is-invalid {
    border-color: #dc3545 !important;
}

.invalid-feedback {
    font-size: 13px;
    color: #dc3545;
    font-weight: 500;
}

</style>

<div class="container-fluid">

    {{-- HEADER --}}
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">
            {{ isset($product) ? 'Edit Product' : 'Add Product' }}
        </h3>

        <a href="{{ route('admin.products') }}" class="btn btn-outline-secondary btn-sm">
            ← Back
        </a>
    </div>

    {{-- FORM CARD --}}
    <div class="card form-card">
        <div class="form-header">
            <h6 class="mb-0 fw-semibold">
                <i class="fa fa-box me-2"></i>
                Product Information
            </h6>
        </div>

        <div class="form-section">

            @if ($errors->has('product'))
                <div class="alert alert-danger mb-3">
                    {{ $errors->first('product') }}
                </div>
            @endif

            <form method="POST"
                  enctype="multipart/form-data"
                  action="{{ isset($product)
                            ? route('admin.products.update', $product)
                            : route('admin.products.store') }}">

                @csrf
                @if(isset($product))
                    @method('PUT')
                @endif

                <div class="row g-3">

                    {{-- BASIC INFO --}}
                    <div class="col-md-3">
                        <label class="form-label">Category</label>
                        <select name="category_id" id="category"
                                class="form-select @error('category_id') is-invalid @enderror" required>
                            <option value="">Category</option>
                            @foreach($categories as $c)
                                <option value="{{ $c->id }}" data-name="{{ strtolower($c->name) }}"
                                    @selected(old('category_id', $product->category_id ?? '') == $c->id)>
                                    {{ $c->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Sub Category</label>
                        <select name="subcategory_id" id="subcategory"
                                class="form-select"
                                data-selected="{{ old('subcategory_id', $product->subcategory_id ?? '') }}">
                            <option value="">Sub Category</option>
                            @foreach($subcategories as $s)
                                <option value="{{ $s->id }}"
                                    @selected(old('subcategory_id', $product->subcategory_id ?? '') == $s->id)>
                                    {{ $s->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Brand</label>
                        <select name="brand_id" id="brand"
                                class="form-select"
                                data-selected="{{ old('brand_id', $product->brand_id ?? '') }}">
                            <option value="">Brand</option>
                            @if(isset($product) && $product->brand_id)
                                <option value="{{ $product->brand_id }}" selected>
                                    {{ $product->brand->name ?? '' }}
                                </option>
                            @endif
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Quantity Unit</label>
                        <select name="quantity_unit_id" id="quantity_unit"
                                class="form-select select2"
                                data-selected="{{ old('quantity_unit_id', $product->quantity_unit_id ?? '') }}">
                            <option value="">Unit</option>
                            @if(isset($product) && $product->quantity_unit_id)
                                <option value="{{ $product->quantity_unit_id }}" selected>
                                    {{ $product->quantityUnit->name ?? '' }}
                                </option>
                            @endif
                        </select>
                    </div>

                    {{-- MEDIA --}}
                    <div class="col-md-4">
                        <label class="form-label">Product Image</label>
                        <input type="file"
                               name="image"
                               class="form-control @error('image') is-invalid @enderror"
                               accept="image/*">
                    </div>

                    <div class="col-md-4">
                        @if(isset($product) && $product->image)
                            <div>
                                <label class="form-label">Preview</label><br>
                                <img src="{{ asset($product->image) }}"
                                     class="img-thumbnail"
                                     width="120"
                                     onerror="this.src='{{ asset('images/no-image.png') }}'">
                            </div>
                        @endif
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="active" @selected(old('status', $product->status ?? '')=='active')>Active</option>
                            <option value="inactive" @selected(old('status', $product->status ?? '')=='inactive')>Inactive</option>
                        </select>
                    </div>

                    {{-- PRICING --}}
                    <div class="col-12 mt-2">
                        <hr>
                        <h6 class="fw-semibold text-muted mb-2">
                            <i class="fa fa-tag me-2"></i> Pricing & Discounts
                        </h6>
                    </div>

                    {{-- STORE --}}
                    <div class="col-md-4">
                        <label class="form-label">Store Price</label>
                        <input type="number" step="0.01"
                               name="store_price"
                               class="form-control"
                               value="{{ old('store_price', $product->store_price ?? '') }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Store Disc Type</label>
                        <select name="store_discount_type" class="form-select">
                            <option value="">None</option>
                            <option value="percentage"
                                @selected(old('store_discount_type', $product->store_discount_type ?? '') == 'percentage')>
                                %
                            </option>
                            <option value="amount"
                                @selected(old('store_discount_type', $product->store_discount_type ?? '') == 'amount')>
                                ₹
                            </option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Store Disc Value</label>
                        <input type="number" step="0.01"
                            name="store_discount_value"
                            class="form-control"
                            value="{{ old('store_discount_value', $product->store_discount_value ?? '') }}">
                    </div>

                    

                    {{-- CUSTOMER --}}
                    <div class="col-md-4">
                        <label class="form-label">Customer Price</label>
                        <input type="number" step="0.01"
                               name="customer_price"
                               class="form-control"
                               value="{{ old('customer_price', $product->customer_price ?? '') }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Cust Disc Type</label>
                        <select name="customer_discount_type" class="form-select">
                            <option value="">None</option>
                            <option value="percentage"
                                @selected(old('customer_discount_type', $product->customer_discount_type ?? '') == 'percentage')>
                                %
                            </option>
                            <option value="amount"
                                @selected(old('customer_discount_type', $product->customer_discount_type ?? '') == 'amount')>
                                ₹
                            </option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Cust Disc Value</label>
                        <input type="number" step="0.01"
                            name="customer_discount_value"
                            class="form-control"
                            value="{{ old('customer_discount_value', $product->customer_discount_value ?? '') }}">
                    </div>

                    {{-- DESCRIPTION --}}
                    <div class="col-12">
                        <label class="form-label">Product Description</label>
                        <textarea name="description"
                                  class="form-control @error('description') is-invalid @enderror"
                                  rows="3"
                                  placeholder="Enter product description">{{ old('description', $product->description ?? '') }}</textarea>
                    </div>

                </div>

                {{-- COLORS --}}
                <div class="col-12 mt-3" id="colors-section" style="display: none;">
                    <label class="form-label fw-semibold">Available Colors</label>

                    <div id="colors-wrapper">
                        @if(old('colors', $product->colors ?? false))
                            @foreach(old('colors', $product->colors ?? []) as $i => $color)
                                <div class="row g-2 align-items-center color-row mb-2">
                                    <div class="col-md-4">
                                        <input type="text"
                                               name="colors[{{ $i }}][name]"
                                               class="form-control"
                                               placeholder="Color Name"
                                               value="{{ $color['name'] ?? '' }}">
                                    </div>

                                    <div class="col-md-3">
                                        <input type="color"
                                               name="colors[{{ $i }}][hex]"
                                               class="form-control form-control-color"
                                               value="{{ $color['hex'] ?? '#000000' }}">
                                    </div>

                                    <div class="col-md-2">
                                        <button type="button" class="btn btn-danger btn-sm remove-color">
                                            Remove
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>

                    <button type="button" class="btn btn-outline-primary btn-sm mt-2" id="add-color">
                        + Add Color
                    </button>
                </div>

                {{-- ACTIONS --}}
                <div class="d-flex justify-content-end gap-3 mt-4">
                    <a href="{{ route('admin.products') }}" class="btn btn-outline-secondary">
                        Cancel
                    </a>

                    <button class="btn-add">
                        <i class="fa fa-save me-2"></i>
                        {{ isset($product) ? 'Update Product' : 'Save Product' }}
                    </button>
                </div>

            </form>
        </div>
    </div>

</div>


@endsection

@section('scripts')

<script>
document.addEventListener('DOMContentLoaded', function () {

    let colorIndex = document.querySelectorAll('.color-row').length;

    document.getElementById('add-color').addEventListener('click', function () {
        const wrapper = document.getElementById('colors-wrapper');

        const html = `
            <div class="row g-2 align-items-center color-row mb-2">
                <div class="col-md-5">
                    <input type="text"
                           name="colors[${colorIndex}][name]"
                           class="form-control"
                           placeholder="Color Name">
                </div>

                <div class="col-md-4">
                    <input type="color"
                           name="colors[${colorIndex}][hex]"
                           class="form-control form-control-color"
                           value="#000000">
                </div>

                <div class="col-md-3">
                    <button type="button" class="btn btn-danger btn-sm remove-color">
                        Remove
                    </button>
                </div>
            </div>
        `;

        wrapper.insertAdjacentHTML('beforeend', html);
        colorIndex++;
    });

    document.addEventListener('click', function (e) {
        if (e.target.classList.contains('remove-color')) {
            e.target.closest('.color-row').remove();
        }
    });

});
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {

    const categorySelect = document.getElementById('category');
    const colorsSection = document.getElementById('colors-section');

    function toggleColors() {
        const selectedOption = categorySelect.options[categorySelect.selectedIndex];
        const categoryName = selectedOption?.dataset?.name;

        if (categoryName === 'paint') {
            colorsSection.style.display = 'block';
        } else {
            colorsSection.style.display = 'none';
        }
    }

    toggleColors(); // edit mode
    categorySelect.addEventListener('change', toggleColors);
});
</script>




<script>
document.addEventListener('DOMContentLoaded', function () {

    const categorySelect = document.getElementById('category');
    const subSelect      = document.getElementById('subcategory');
    const unitSelect     = document.getElementById('quantity_unit');
    const brandSelect    = document.getElementById('brand');

    function loadByCategory(categoryId) {
        if (!categoryId) return;

        // SUBCATEGORIES
        fetch(`/admin/subcategories/by-category/${categoryId}`)
            .then(res => res.json())
            .then(data => {
                const selected = subSelect.dataset.selected;
                subSelect.innerHTML = '<option value="">Select Sub Category</option>';
                data.forEach(item => {
                    subSelect.innerHTML +=
                        `<option value="${item.id}" ${item.id == selected ? 'selected' : ''}>
                            ${item.name}
                        </option>`;
                });
            });

        fetch(`/admin/quantity-units/by-category/${categoryId}`)
            .then(res => res.json())
            .then(data => {
                const selected = unitSelect.dataset.selected;
                unitSelect.innerHTML = '<option value="">Select Quantity Unit</option>';
                data.forEach(item => {
                    unitSelect.innerHTML +=
                        `<option value="${item.id}" ${item.id == selected ? 'selected' : ''}>
                            ${item.name}
                        </option>`;
                });
            });

        fetch(`/admin/brands/by-category/${categoryId}`)
            .then(res => res.json())
            .then(data => {
                const selected = brandSelect.dataset.selected;
                brandSelect.innerHTML = '<option value="">Select Brand</option>';
                data.forEach(item => {
                    brandSelect.innerHTML +=
                        `<option value="${item.id}" ${item.id == selected ? 'selected' : ''}>
                            ${item.name}
                        </option>`;
                });
            });
    }

    // ON CHANGE
    categorySelect.addEventListener('change', function () {
        loadByCategory(this.value);
    });

    // 🔥 AUTO LOAD FOR EDIT MODE
    if (categorySelect.value) {
        loadByCategory(categorySelect.value);
    }
});
</script>

@endsection
