@extends('admin.layouts.app')

@section('title', 'Sub-Category Management')

@section('styles')
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet">

<style>
/* ===============================
   DATATABLE HEADER
=============================== */
.dataTables_wrapper table.dataTable thead th {
    background: linear-gradient(to bottom, #29B2F6, #5AF399) !important;
    color: #fff !important;
    font-size: 13px;
    font-weight: 600;
    text-transform: uppercase;
    text-align: center;
    border: none !important;
}

.dataTables_wrapper table.dataTable thead th:first-child {
    border-top-left-radius: 12px;
}
.dataTables_wrapper table.dataTable thead th:last-child {
    border-top-right-radius: 12px;
}

.dataTables_wrapper table.dataTable {
    margin-top: 12px !important;
}

.dataTables_wrapper .dataTables_filter {
    margin-bottom: 16px;
}

/* ===============================
   TABLE BODY
=============================== */
table.dataTable tbody td {
    text-align: center;
    font-size: 14px;
    border-top: 1px solid #eef2f6;
}

table.dataTable tbody tr:nth-child(odd) {
    background: #f8fbff;
}
table.dataTable tbody tr:nth-child(even) {
    background: #fff;
}

table.dataTable tbody tr {
    transition: all .25s ease;
}
table.dataTable tbody tr:hover {
    background: #e9f6ff !important;
    box-shadow: 0 6px 18px rgba(41,178,246,.15);
}

/* Active page button */
.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    border: none !important;
    border-radius: 8px !important;
    box-shadow: 0 4px 10px rgba(41,178,246,.35);
}
/* ===============================
   ICON ACTION BUTTONS (FIXED)
=============================== */
.icon-btn {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    border: none;
    background: #f1f5f9;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all .2s ease;
}

.icon-btn i {
    font-size: 15px;
}

/* EDIT */
.approve-btn {
    color: #0d6efd !important;
}
.approve-btn:hover {
    background: rgba(13,110,253,.15);
    transform: translateY(-2px);
}

/* DELETE */
.reject-btn {
    color: #ef4444 !important;
}
.reject-btn:hover {
    background: rgba(239,68,68,.15);
    transform: translateY(-2px);
}


/* ===============================
   ADD BUTTON
=============================== */
.btn-add {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-radius: 20px;
    padding: 8px 20px;
    font-weight: 600;
    border: none;
}

/* ===============================
   MODAL FIX (CENTERED & CLEAN)
=============================== */
.modal {
    overflow-y: auto;
    padding-right: 0 !important;
}

.modal-dialog.modal-wide {
    max-width: 900px;   /* change as you want */
    width: 90%;
}


.modal-dialog {
    margin: auto !important;
    max-width: 500px !important;
    justify-content: center !important;
}

.modal-content {
    border-radius: 14px;
    border: none;
    box-shadow: 0 15px 40px rgba(0,0,0,.15);
}

.modal-header {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-top-left-radius: 14px;
    border-top-right-radius: 14px;
}

.modal-footer .btn {
    border-radius: 20px;
}

/* ===============================
   INPUTS
=============================== */
.form-control {
    border-radius: 10px;
}

/* ===============================
   MOBILE FIX
=============================== */
@media (max-width: 768px) {
    .table-responsive {
        overflow-x: auto;
    }
    table.dataTable {
        min-width: 700px;
    }
}

.status {
    padding: 6px 16px;
    font-size: 12px;
    font-weight: 600;
    border-radius: 30px;
    display: inline-block;
}

.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-inactive { background: #fdecea; color: #c62828; }
</style>
@endsection


@section('content')
<div class="container-fluid">

    {{-- HEADER --}}
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">SubCategory Management</h3>
        <button class="btn-add" data-bs-toggle="modal" data-bs-target="#addSubCategoryModal">
            <i class="fa fa-plus me-2"></i> Add SubCategory
        </button>
    </div>

    {{-- TABLE --}}
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table id="subcategory-table" class="display w-100">
                    <thead>
                        <tr>
                            <th>S.no</th>
                            <th>Image</th> 
                            <th>SubCategory Name</th>
                            <th>Parent Category</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach($subcategories as $subcategory)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>
                                @if($subcategory->image)
                                    <img src="{{ asset($subcategory->image) }}"
                                        width="50" height="50"
                                        class="rounded"
                                        style="object-fit:cover">
                                @else
                                    <span class="text-muted">No Image</span>
                                @endif
                            </td>
                            <td class="fw-semibold">{{ $subcategory->name }}</td>
                            <td>{{ $subcategory->category->name }}</td>
                            <td>
                                <span class="status status-{{ $subcategory->status }}">
                                    {{ ucfirst($subcategory->status) }}
                                </span>
                            </td>
                            <td>
                                <button class="icon-btn approve-btn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#editSubCategoryModal"
                                        data-id="{{ $subcategory->id }}"
                                        data-name="{{ $subcategory->name }}"
                                        data-status="{{ $subcategory->status }}"
                                        data-category="{{ $subcategory->category_id }}">
                                    <i class="fa fa-pen"></i>
                                </button>
                                <button class="icon-btn reject-btn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#deleteSubCategoryModal"
                                        data-id="{{ $subcategory->id }}"
                                        data-name="{{ $subcategory->name }}">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>

                </table>
            </div>
        </div>
    </div>
</div>

{{-- ADD SUBCATEGORY MODAL --}}
<div class="modal fade" id="addSubCategoryModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-wide">
        <form method="POST" action="{{ route('admin.subcategories.store') }}" enctype="multipart/form-data">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Add SubCategory</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <label class="detail-label mb-1">Parent Category</label>
                    <select name="category_id" class="form-control mb-3" required>
                        <option value="">Select Category</option>
                        @foreach($categories as $cat)
                        <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                        @endforeach
                    </select>

                    <label class="detail-label mb-1 mt-3">SubCategory Image</label>
                    <input type="file"
                        name="image"
                        class="form-control"
                        accept="image/*">


                    <label class="detail-label mb-1">SubCategory Name</label>
                    <input type="text" name="name" class="form-control" placeholder="SubCategory Name" required>

                    <label class="detail-label mb-1 mt-3">Status</label>
                    <select name="status" class="form-control">
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success px-4">Save</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- EDIT SUBCATEGORY MODAL --}}
<div class="modal fade" id="editSubCategoryModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="editSubCategoryForm" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Edit SubCategory</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">

                    <label class="detail-label mb-1">SubCategory Name</label>
                    <input type="text" name="name" id="editSubCategoryName" class="form-control" required>

                    <label class="detail-label mb-1 mt-3">SubCategory Image</label>
                    <input type="file"
                        name="image"
                        class="form-control"
                        accept="image/*">


                    <label class="detail-label mb-1 mt-3">Parent Category</label>
                    <select name="category_id" id="editSubCategoryParent" class="form-control" required>
                        @foreach($categories as $cat)
                        <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                        @endforeach
                    </select>

                    <label class="detail-label mb-1 mt-3">Status</label>
                    <select name="status" id="editSubCategoryStatus" class="form-control">
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                    <span id="subStatusPreview" class="status mt-2 d-inline-block"></span>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success px-4">Update</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- DELETE SUBCATEGORY MODAL --}}
<div class="modal fade" id="deleteSubCategoryModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="deleteSubCategoryForm">
            @csrf
            @method('DELETE')
            <div class="modal-content">
                <div class="modal-header bg-danger">
                    <h5>Confirm Delete</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete <strong id="deleteSubCategoryName"></strong>?
                </div>
                <div class="modal-footer">
                    <button class="btn btn-danger px-4">Delete</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script>
$(function () {

    $('#subcategory-table').DataTable({
        pageLength: 10,
        columnDefs: [{ orderable: false, targets: [1,5] }]
    });

    $('#editSubCategoryModal').on('show.bs.modal', function (e) {
        let btn = $(e.relatedTarget);
        $('#editSubCategoryName').val(btn.data('name'));
        $('#editSubCategoryParent').val(btn.data('category'));
        $('#editSubCategoryStatus').val(btn.data('status'));

        $('#subStatusPreview')
            .attr('class', 'status status-' + btn.data('status'))
            .text(btn.data('status').charAt(0).toUpperCase() + btn.data('status').slice(1));

        $('#editSubCategoryForm').attr('action',
            "{{ route('admin.subcategories.update', ':id') }}".replace(':id', btn.data('id'))
        );
    });

    // Status preview update
    $('#editSubCategoryStatus').on('change', function(){
        let val = $(this).val();
        $('#subStatusPreview')
            .attr('class', 'status status-' + val)
            .text(val.charAt(0).toUpperCase() + val.slice(1));
    });

    // Delete SubCategory
    $('#deleteSubCategoryModal').on('show.bs.modal', function (e) {
        let btn = $(e.relatedTarget);
        $('#deleteSubCategoryName').text(btn.data('name'));
        $('#deleteSubCategoryForm').attr('action',
            "{{ route('admin.subcategories.destroy', ':id') }}".replace(':id', btn.data('id'))
        );
    });

});
</script>
@endsection