@extends('admin.layouts.app')

@section('title', 'Store Management')

@section('styles')
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet">

<style>
/* ===============================
   DATATABLE HEADER (FIXED)
=============================== */
.dataTables_wrapper table.dataTable thead th {
    background: linear-gradient(to bottom, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: .05em;
    text-align: center;
    border: none !important;
}

.dataTables_wrapper table.dataTable thead tr {
    background: none !important;
}

/* Rounded header */
.dataTables_wrapper table.dataTable thead th:first-child {
    border-top-left-radius: 12px;
}
.dataTables_wrapper table.dataTable thead th:last-child {
    border-top-right-radius: 12px;
}
/* Space below search bar */
.dataTables_wrapper .dataTables_filter {
    margin-bottom: 16px;
}

/* Space above table */
.dataTables_wrapper table.dataTable {
    margin-top: 12px !important;
}


@media (max-width: 768px) {

    .dataTables_wrapper {
        overflow-x: auto !important;
        -webkit-overflow-scrolling: touch;
    }

    .table-responsive {
        overflow-x: auto !important;
    }

    table.dataTable {
        min-width: 900px; /* forces horizontal scroll */
    }
}

/* ===============================
   TABLE BODY
=============================== */
table.dataTable tbody td {
    font-size: 14px;
    color: #374151;
    border-top: 1px solid #eef2f6;
    text-align: center;
}

/* Zebra rows */
table.dataTable tbody tr:nth-child(odd) {
    background-color: #f8fbff;
}
table.dataTable tbody tr:nth-child(even) {
    background-color: #ffffff;
}

/* ===============================
   ANIMATED ROW HOVER (PRO)
=============================== */
table.dataTable tbody tr {
    transition: all 0.25s ease;
}

table.dataTable tbody tr:hover {
    background-color: #e9f6ff !important;
    transform: scale(1.01);
    box-shadow: 0 6px 18px rgba(41,178,246,.15);
    z-index: 2;
    position: relative;
}

.dataTables_wrapper {
    overflow: hidden;
}

.table-responsive {
    overflow-x: hidden;
}


/* ===============================
   STATUS BADGES
=============================== */
.status {
    padding: 6px 16px;
    font-size: 12px;
    font-weight: 600;
    border-radius: 30px;
    display: inline-block;
}

.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-pending { background: #fff5e5; color: #d48806; }
.status-rejected { background: #fdecea; color: #c62828; }

/* ===============================
   ACTION BUTTONS
=============================== */
.action-btn {
    border: none;
    background: none;
    font-size: 20px;
    margin: 0 8px;
    cursor: pointer;
    transition: transform .2s;
}

.action-btn:hover {
    transform: scale(1.2);
}

.action-approve { color: #22c55e; }
.action-reject { color: #ef4444; }

/* ===============================
   DATATABLE CONTROLS
=============================== */
.dataTables_filter input {
    border-radius: 20px;
    padding: 6px 14px;
    border: 1px solid #d1d5db;
}

.dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #29B2F6, #5AF399) !important;
    color: #fff !important;
    border-radius: 6px;
}

/* ===============================
   MODALS
=============================== */
.modal-header {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
}

.modal-footer .btn {
    border-radius: 20px;
}
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">Store Management</h3>
        <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary btn-sm">
            ← Dashboard
        </a>
    </div>

    <div class="card border-0 shadow-lg rounded-4">
        <div class="card-body">
            <div class="table-responsive">
                <table id="stores-table" class="display w-100">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Owner Name</th>
                            <th>Store Name</th>
                            <th>Email</th>
                            <th>Mobile</th>
                            <th>City</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach($stores as $store)
                        <tr>
                            <td>{{ $stores->count() - $loop->index }}</td>

                            <td class="fw-semibold text-start">
                                {{ $store->owner_name }}
                            </td>

                            <td class="fw-semibold text-start">
                                {{ $store->store_name }}
                            </td>

                            <td class="text-start">
                                {{ $store->email }}
                            </td>

                            <td>
                                {{ $store->mobile_number }}
                            </td>

                            <td>
                                {{ $store->city }}
                            </td>

                            <td>
                                @if($store->status === 'active')
                                    <span class="status status-active">Active</span>
                                @elseif($store->status === 'pending_admin')
                                    <span class="status status-pending">Pending</span>
                                @else
                                    <span class="status status-rejected">Rejected</span>
                                @endif
                            </td>

                            <td>
                                {{-- VIEW --}}
                                <a href="{{ route('admin.users.store.show', $store->id) }}"
                                   class="btn btn-info btn-sm p-2"
                                   title="View Details">
                                    <i class="fa fa-eye"></i>
                                </a>

                                {{-- APPROVE / REJECT --}}
                                @if($store->status === 'pending_admin')
                                    <button class="action-btn action-approve"
                                            data-bs-toggle="modal"
                                            data-bs-target="#approveModal"
                                            data-id="{{ $store->id }}">
                                        <i class="fa fa-check-circle"></i>
                                    </button>

                                    <button class="action-btn action-reject"
                                            data-bs-toggle="modal"
                                            data-bs-target="#rejectModal"
                                            data-id="{{ $store->id }}">
                                        <i class="fa fa-times-circle"></i>
                                    </button>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>

                </table>
            </div>
        </div>
    </div>

</div>

{{-- APPROVE MODAL --}}
<div class="modal fade" id="approveModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="approveForm">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Approve Store</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <p>Are you sure you want to approve this store?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success px-4">Approve</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- REJECT MODAL --}}
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="rejectForm">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reject Store</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <p>Are you sure you want to reject this store?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-danger px-4">Reject</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
$(function () {

    $('#warehouses-table').DataTable({
        pageLength: 10,
        // order: [[0, 'desc']],
        columnDefs: [{ orderable: false, targets: 6 }]
    });

   $('#approveModal').on('show.bs.modal', function (e) {
        let id = $(e.relatedTarget).data('id');
        let url = "{{ route('admin.users.approve', ['type' => 'warehouse', 'id' => ':id']) }}";
        url = url.replace(':id', id);
        $('#approveForm').attr('action', url);
    });

    $('#rejectModal').on('show.bs.modal', function (e) {
        let id = $(e.relatedTarget).data('id');
        let url = "{{ route('admin.users.reject', ['type' => 'warehouse', 'id' => ':id']) }}";
        url = url.replace(':id', id);
        $('#rejectForm').attr('action', url);
    });
});
</script>
@endsection
