@extends('admin.layouts.app')

@section('title', 'Store Details')

@section('styles')
<style>
/* ===============================
   DETAIL PAGE STYLING
=============================== */

/* Card shadow and rounded corners */
.card {
    border: none;
    border-radius: 12px;
    box-shadow: 0 8px 20px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
}

/* Card header gradient */
.card-header {
    background: linear-gradient(to bottom, #29B2F6, #5AF399);
    color: #fff;
    font-weight: 600;
    font-size: 1.1rem;
    border-top-left-radius: 12px;
    border-top-right-radius: 12px;
}

/* Row spacing */
.detail-row {
    margin-bottom: 1rem;
}

/* Labels */
.detail-label {
    font-weight: 600;
    color: #374151;
}

/* Values */
.detail-value {
    color: #111827;
}

/* Badge styling for status */
.status-badge {
    padding: 6px 16px;
    border-radius: 30px;
    font-weight: 600;
    font-size: 0.9rem;
}

.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-pending { background: #fff5e5; color: #d48806; }
.status-rejected { background: #fdecea; color: #c62828; }

/* Back button */
.btn-back {
    background: #f0f4f8;
    color: #10171d;
    font-weight: 500;
    border-radius: 8px;
    transition: 0.3s;
}

.btn-back:hover {
    background: #e0efff;
    color: #0d4f9c;
}

/* Approve/Reject buttons */
.action-btn {
    padding: 10px 24px;
    border-radius: 8px;
    font-weight: 600;
    font-size: 0.95rem;
    margin-right: 12px;
    cursor: pointer;
    border: none;
    transition: 0.3s;
}

.action-approve { background: #22c55e; color: #fff; }
.action-approve:hover { background: #16a34a; }

.action-reject { background: #ef4444; color: #fff; }
.action-reject:hover { background: #b91c1c; }

/* Responsive layout */
@media (max-width: 768px) {
    .detail-label, .detail-value {
        display: block;
    }

    .action-btn {
        width: 100%;
        margin-bottom: 8px;
    }
}

/* Modals */
.modal-header {
    background: linear-gradient(to bottom, #29B2F6, #5AF399);
    color: #fff;
}
.modal-footer .btn {
    border-radius: 20px;
}
</style>
@endsection

@section('content')
<div class="container-fluid">

    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap">
        <h3 class="fw-semibold">Store Details</h3>
        <a href="{{ route('admin.users.stores') }}" class="btn btn-back btn-sm">
            ← Back to Stores
        </a>
    </div>

    <!-- Approve / Reject Buttons -->
    @if($store->status == 'pending_admin')
    <div class="mb-4 d-flex flex-wrap">
        <button class="action-btn action-approve"
                data-bs-toggle="modal"
                data-bs-target="#approveModal">
            Approve
        </button>
        <button class="action-btn action-reject"
                data-bs-toggle="modal"
                data-bs-target="#rejectModal">
            Reject
        </button>
    </div>
    @endif

    <!-- Warehouse Info Card -->
    <div class="card">
        <div class="card-header">
            General Information
        </div>
        <div class="card-body">
            <div class="row detail-row">
                <div class="col-md-6">
                    <span class="detail-label">Name:</span>
                    <span class="detail-value">{{ $store->name }}</span>
                </div>
                <div class="col-md-6">
                    <span class="detail-label">Email:</span>
                    <span class="detail-value">{{ $store->email }}</span>
                </div>
            </div>

            <div class="row detail-row">
                <div class="col-md-6">
                    <span class="detail-label">Mobile Number:</span>
                    <span class="detail-value">{{ $store->mobile_number }}</span>
                </div>
                <div class="col-md-6">
                    <span class="detail-label">Status:</span>
                    <span class="status-badge
                        @if($store->status == 'active') status-active
                        @elseif($store->status == 'pending_admin') status-pending
                        @else status-rejected @endif">
                        {{ ucfirst($store->status) }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Address Card -->
    <div class="card mb-4">
        <div class="card-header">
            Address
        </div>
        <div class="card-body">
            <p class="mb-2">{{ $store->door_no }}, {{ $store->street_name }}</p>
            <p class="mb-2">{{ $store->area }}</p>
            <p class="mb-2">{{ $store->city }}</p>
            <p class="mb-2">{{ $store->district }}</p>
            <p class="mb-2">{{ $store->state }}</p>
            <p class="mb-2">{{ $store->country }}</p>
            <p class="mb-0">{{ $store->pincode }}</p>
        </div>
    </div>

    <!-- Bank & Legal Info Card -->
    <div class="card">
        <div class="card-header">
            Bank & Legal Information
        </div>
        <div class="card-body">
            <div class="row detail-row">
                <div class="col-md-6">
                    <span class="detail-label">Bank Name:</span>
                    <span class="detail-value">{{ $store->bank_name }}</span>
                </div>
                <div class="col-md-6">
                    <span class="detail-label">Bank Account No:</span>
                    <span class="detail-value">{{ $store->bank_account_number }}</span>
                </div>
            </div>

            <div class="row detail-row">
                <div class="col-md-6">
                    <span class="detail-label">IFSC Code:</span>
                    <span class="detail-value">{{ $store->ifsc_code }}</span>
                </div>
                <div class="col-md-6">
                    <span class="detail-label">GST Number:</span>
                    <span class="detail-value">{{ $store->gst_number ?? 'N/A' }}</span>
                </div>
            </div>

            <div class="row detail-row">
                <div class="col-md-6">
                    <span class="detail-label">PAN Number:</span>
                    <span class="detail-value">{{ $store->pan_number }}</span>
                </div>
                <div class="col-md-6">
                    <span class="detail-label">Store Type:</span>
                    <span class="detail-value">{{ $store->store_type ?? 'N/A' }}</span>
                </div>
            </div>
        </div>
    </div>

</div>

{{-- APPROVE MODAL --}}
<div class="modal fade" id="approveModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="{{ route('admin.users.approve', ['type' => 'store', 'id' => $store->id]) }}">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Approve Store</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <p>Are you sure you want to approve this store?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success px-4">Approve</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- REJECT MODAL --}}
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="{{ route('admin.users.reject', ['type' => 'store', 'id' => $store->id]) }}">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reject Store</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <p>Are you sure you want to reject this store?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-danger px-4">Reject</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
