<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Buildours - Order Delivered!</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
        }
        .email-container {
            max-width: 650px;
            margin: 30px auto;
            background-color: #ffffff;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .header {
            background-color: #0d6efd;
            padding: 25px;
            text-align: center;
        }
        .header img {
            height: 50px;
        }
        .content {
            padding: 40px 30px;
            text-align: center;
        }
        .content h2 {
            color: #333333;
            font-size: 28px;
            margin-bottom: 15px;
        }
        .content p {
            color: #555555;
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 20px;
        }
        .order-number {
            font-size: 18px;
            color: #0d6efd;
            font-weight: bold;
            margin-bottom: 25px;
        }
        .product-details {
            text-align: left;
            margin: 30px auto;
            max-width: 450px;
            border: 1px solid #eee;
            border-radius: 10px;
            padding: 20px;
            background-color: #fafafa;
        }
        .product-details p {
            margin: 5px 0;
            font-size: 16px;
        }
        .product-details .label {
            font-weight: bold;
            color: #333;
        }
        .price {
            color: #0d6efd;
            font-size: 18px;
            font-weight: bold;
        }
        .totals {
            text-align: right;
            max-width: 450px;
            margin: 20px auto 0 auto;
        }
        .totals p {
            margin: 5px 0;
            font-size: 16px;
        }
        .totals .total-payable {
            font-size: 18px;
            font-weight: bold;
            color: #0d6efd;
        }
        .footer {
            background-color: #f1f1f1;
            padding: 20px;
            text-align: center;
            font-size: 12px;
            color: #888888;
        }
    </style>
</head>
<body>
    <div style="font-family: Arial, sans-serif; max-width:600px; margin:30px auto; background:#fff; border-radius:8px; box-shadow:0 2px 8px rgba(0,0,0,0.1); overflow:hidden;">
        
        <!-- Header -->
        <div style="background:#28a745; padding:20px; text-align:center;">
            <img src="{{ $message->embed(public_path('assets/images/logo.jpg')) }}" alt="Buildours Logo" style="height:80px;">
        </div>

        <!-- Content -->
        <div style="padding:30px 20px; text-align:center;">
            <h2 style="color:#333;">Order Delivered!</h2>
            <p style="color:#555; font-size:16px; line-height:1.5;">
                The order placed by your customer has been <strong>successfully delivered</strong>.
            </p>

            <div style="margin:20px 0; font-size:16px;">
                <strong>Order Number:</strong> {{ $order->order_no }}<br>
                <strong>Invoice Number:</strong> {{ $order->invoice_no ?? 'N/A' }}
            </div>

            <!-- Customer & Product Details -->
            <div style="text-align:left; margin:10px; border-top:1px solid #eee; border-bottom:1px solid #eee; padding:10px 0;">
                <h3 style="color:#333; margin-bottom:10px;">Customer & Product Details</h3>
                <p><strong>Customer Type:</strong> {{ ucfirst($order->user_type) }}</p>
                <p><strong>Customer ID:</strong> {{ $order->user_id }}</p>
                <p><strong>Product:</strong> {{ $order->item->brand ?? 'N/A' }} - {{ $order->item->subcategory_name ?? 'N/A' }}</p>
                <p><strong>Quantity:</strong> {{ $order->item->quantity ?? 1 }} {{ $order->item->quantity_unit ?? '' }}</p>
                <p><strong>Total Price:</strong> ₹{{ number_format($order->item->total_price ?? 0, 2) }}</p>
            </div>

            <p style="color:#555; font-size:16px; line-height:1.5;">
                Thank you for your prompt service! Keep track of your orders in your seller dashboard.
            </p>
        </div>

        <!-- Footer -->
        <div style="background:#f1f1f1; padding:15px; text-align:center; font-size:12px; color:#888;">
            &copy; {{ date('Y') }} Buildours. All rights reserved.<br>
            If you did not process this order, please contact support immediately.
        </div>
    </div>
</body>
</html>
