<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice</title>

    <style>
        body {
            font-family: DejaVu Sans;
            font-size: 12px;
            color: #000;
        }

        .header {
            width: 100%;
            border-bottom: 2px solid #000;
            margin-bottom: 10px;
        }

        .logo {
            width: 150px;
        }

        .company-details {
            text-align: right;
            font-size: 11px;
        }

        .invoice-title {
            font-size: 18px;
            font-weight: bold;
            margin-top: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            border: 1px solid #999;
            padding: 6px;
        }

        th {
            background-color: #f2f2f2;
            text-align: center;
        }

        .no-border td {
            border: none;
            padding: 3px;
        }

        .right {
            text-align: right;
        }

        .center {
            text-align: center;
        }

        .summary td {
            border: none;
            padding: 4px;
        }

        .footer {
            margin-top: 25px;
            font-size: 10px;
        }

        .signature {
            text-align: right;
            margin-top: 40px;
        }
    </style>
</head>
<body>

<!-- HEADER -->
<table class="header no-border">
    <tr>
        <td>
            <img src="{{ public_path('logo.png') }}" class="logo">
        </td>
        <td class="company-details">
            <strong>BuildOurs Pvt Ltd</strong><br>
            123, Industrial Area<br>
            Chennai, Tamil Nadu – 600001<br>
            Phone: +91 98765 43210<br>
            Email: support@buildours.com<br>
            Website: www.buildours.com
        </td>
    </tr>
</table>

<div class="invoice-title center">TAX INVOICE</div>

<!-- INVOICE META -->
<table class="no-border">
    <tr>
        <td>
            <strong>Invoice No:</strong> {{ $invoice['invoice_no'] }}<br>
            <strong>Invoice Date:</strong> {{ $invoice['invoice_date'] }} {{ $invoice['invoice_time'] }}
        </td>
        <td>
            <strong>Order No:</strong> {{ $invoice['order_no'] }}<br>
            <strong>Order Date:</strong> {{ $invoice['order_date'] }}
        </td>
    </tr>
</table>

<!-- DELIVERY ADDRESS -->
<h4>Bill To</h4>
<p>
    <strong>{{ $invoice['delivery_address']['name'] }}</strong><br>
    {{ $invoice['delivery_address']['door_no'] }},
    {{ $invoice['delivery_address']['street'] }},
    {{ $invoice['delivery_address']['area'] }},
    {{ $invoice['delivery_address']['city'] }}<br>
    {{ $invoice['delivery_address']['district'] }},
    {{ $invoice['delivery_address']['state'] }} - {{ $invoice['delivery_address']['pincode'] }}<br>
    Phone: {{ $invoice['delivery_address']['phone'] }}
</p>

<tbody>
    <tr>
        <td class="center">1</td>

        <td>
            {{ $invoice['item']['category'] ?? '-' }}

            @if(!empty($invoice['item']['subcategory']))
                / {{ $invoice['item']['subcategory'] }}
            @endif

            @if(!empty($invoice['item']['brand']))
                ({{ $invoice['item']['brand'] }})
            @endif
        </td>

        <td class="center">
            {{ $invoice['item']['quantity'] ?? 1 }}
            {{ $invoice['item']['quantity_unit'] ?? '' }}
        </td>

        <td class="right">
            ₹ {{ number_format($invoice['item']['unit_price'] ?? 0, 2) }}
        </td>

        <td class="right">
            ₹ {{ number_format($invoice['item']['total_price'] ?? 0, 2) }}
        </td>
    </tr>
</tbody>

<!-- PAYMENT SUMMARY -->
<table class="summary" width="100%">
    <tr>
        <td width="70%"></td>
        <td width="30%">
            <table width="100%">
                <tr>
                    <td>Items Total</td>
                    <td class="right">₹ {{ number_format($invoice['items_total'], 2) }}</td>
                </tr>
                <tr>
                    <td>Delivery Charge</td>
                    <td class="right">₹ {{ number_format($invoice['delivery_fee'], 2) }}</td>
                </tr>
                <tr>
                    <td><strong>Grand Total</strong></td>
                    <td class="right"><strong>₹ {{ number_format($invoice['grand_total'], 2) }}</strong></td>
                </tr>
            </table>
        </td>
    </tr>
</table>

<p><strong>Amount in Words:</strong> {{ $amountInWords }}</p>

<!-- PAYMENT DETAILS -->
<h4>Payment Details</h4>
<table>
    <tr>
        <td>Payment Mode</td>
        <td>{{ $invoice['payment_method'] }}</td>
    </tr>
    <tr>
        <td>Payment Status</td>
        <td>{{ $invoice['payment_status'] }}</td>
    </tr>
    @if($invoice['transaction_id'])
    <tr>
        <td>Transaction ID</td>
        <td>{{ $invoice['transaction_id'] }}</td>
    </tr>
    @endif
</table>

<!-- TERMS -->
<div class="footer">
    <strong>Terms & Conditions</strong>
    <ol>
        <li>Goods once sold cannot be returned.</li>
        <li>Invoice is valid only if payment is successful.</li>
        <li>Subject to Tamil Nadu jurisdiction.</li>
    </ol>
</div>

<!-- SIGNATURE -->
<div class="signature">
    For <strong>BuildOurs Pvt Ltd</strong><br><br>
    ___________________________<br>
    Authorized Signatory
</div>

<p style="font-size:10px; text-align:center;">
This is a system-generated invoice and does not require a physical signature.
</p>

</body>
</html>
