<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice #{{ $invoice['invoice_no'] }}</title>
    <style>
        body { font-family: 'Helvetica', Arial, sans-serif; font-size: 12px; color: #333; margin:0; padding:0; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 10px; }
        th, td { padding: 8px; vertical-align: top; }
        th { background: #f7f7f7; text-align: center; font-weight: bold; border-bottom: 1px solid #ccc; }
        td { border-bottom: 1px solid #eee; }
        .no-border td, .no-border th { border:none; padding: 4px; }
        .header { background:#f2f2f2; padding:10px; }
        .header h2 { margin:0; color:#222; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .invoice-label { font-size:12px; font-weight:bold; text-align:right; color:#555; padding-right: 16px;}
        .desc-box { line-height:1.3; }
        .total-row { font-weight:bold; background:#f9f9f9; }
        .signature { text-align:center; margin-top:20px; }
        .footer-note { position:fixed; bottom:10px; width:100%; text-align:center; font-size:12px; color:#555;}
        .section-title { background:#f7f7f7; padding:5px 10px; font-weight:bold; }
        .bordered { border:1px solid #ccc; }
        a { color:#1a73e8; text-decoration:none; }
        img.logo { max-width:150px; height:auto; display:block; margin:0 auto; }
    </style>
</head>
<body>

<!-- Header Section -->
<table class="bordered">
    <tr>
        <td width="25%" class="text-center" style="vertical-align:middle;">
            <img src="{{ public_path('assets/images/logo.jpg') }}" class="logo" alt="Logo">
        </td>
        <td width="50%" class="text-center" style="vertical-align:middle; padding-left:15px;">
            <h2 style="margin-bottom:5px; font-size:25px;">Buildours</h2>
            <p style="margin:2px 0;">Location: Adavathur, Trichy</p>
            <p style="margin:2px 0;">
                <a href="tel:+918148195967">+91 8148195967</a> | 
                <a href="mailto:buildoursapps@gmail.com">buildoursapps@gmail.com</a>
            </p>
        </td>
        <td width="25%" class="text-center" style="vertical-align:middle;">
            <div style="font-size:20px; font-weight:bold;">TAX INVOICE</div>
            <div class="invoice-label">Original for Recipient</div>
        </td>
    </tr>
</table>

<!-- Invoice & Order Details -->
<table class="bordered" style="margin-top:10px;">
    <tr>
        <td style="width:50%; vertical-align:top;">
            <div class="section-title">Invoice Details</div>
            <p style="margin:3px 0;"><strong>Invoice No:</strong> {{ $invoice['invoice_no'] }}</p>
            <p style="margin:3px 0;"><strong>Invoice Date:</strong> {{ \Carbon\Carbon::parse($invoice['invoice_date'])->format('d-m-Y') }}</p>
            <p style="margin:3px 0;"><strong>Payment Method:</strong> {{ $invoice['payment_summary']['payment_method'] }}</p>
        </td>
        <td style="width:50%; vertical-align:top;">
            <div class="section-title">Order Details</div>
            <p style="margin:3px 0;"><strong>Order No:</strong> {{ $invoice['order_no'] }}</p>
            <p style="margin:3px 0;"><strong>Order Date:</strong> {{ \Carbon\Carbon::parse($invoice['order_date'])->format('d-m-Y') }}</p>
        </td>
    </tr>
</table>

<!-- Bill To / Ship To -->
<table class="bordered" style="margin-top:10px;">
    <tr>
        <th>Bill To</th>
        <th>Ship To</th>
    </tr>
    <tr>
        <td>
            <strong>{{ $invoice['delivery_address']['name'] }}</strong><br>
            {{ $invoice['delivery_address']['door_no'] }}, {{ $invoice['delivery_address']['street'] }}<br>
            {{ $invoice['delivery_address']['area'] }}, {{ $invoice['delivery_address']['city'] }}<br>
            {{ $invoice['delivery_address']['district'] }}, {{ $invoice['delivery_address']['state'] }} - {{ $invoice['delivery_address']['pincode'] }}<br>
            Phone: {{ $invoice['delivery_address']['phone'] }}
        </td>
        <td>
            <strong>{{ $invoice['delivery_address']['name'] }}</strong><br>
            {{ $invoice['delivery_address']['door_no'] }}, {{ $invoice['delivery_address']['street'] }}<br>
            {{ $invoice['delivery_address']['area'] }}, {{ $invoice['delivery_address']['city'] }}<br>
            {{ $invoice['delivery_address']['district'] }}, {{ $invoice['delivery_address']['state'] }} - {{ $invoice['delivery_address']['pincode'] }}<br>
            Phone: {{ $invoice['delivery_address']['phone'] }}
        </td>
    </tr>
</table>

<!-- Products Table -->
<table class="bordered" style="margin-top:10px;">
    <thead>
        <tr>
            <th>#</th>
            <th>Product</th>
            <th>Category</th>
            <th>Brand</th>
            <th>Qty</th>
            <th>Unit Price</th>
            <th>Total</th>
        </tr>
    </thead>
    <tbody>
        @foreach($invoice['materials'] as $index => $item)
        <tr>
            <td class="text-center">{{ $index + 1 }}</td>
            <td class="desc-box">
                @if($item['image'])
                    <img src="{{ public_path($item['image']) }}" width="50"><br>
                @endif
                {{ $item['subcategory'] ?? '' }} - {{ $item['category'] ?? '' }}
            </td>
            <td class="text-center">{{ $item['category'] ?? '' }}</td>
            <td class="text-center">{{ $item['brand'] ?? '' }}</td>
            <td class="text-center">{{ $item['quantity'] }} {{ $item['quantity_unit'] ?? '' }}</td>
            <td class="text-right">{{ number_format($item['unit_price'], 2) }}</td>
            <td class="text-right">{{ number_format($item['total_price'], 2) }}</td>
        </tr>
        @endforeach
    </tbody>
    <tfoot>
        <tr class="total-row">
            <th colspan="6" class="text-right">Delivery Charge</th>
            <th class="text-right">{{ number_format($invoice['payment_summary']['delivery_charge'],2) }}</th>
        </tr>
        @if(isset($invoice['paid_pending']) && $invoice['paid_pending'] > 0)
        <tr class="total-row">
            <th colspan="6" class="text-right" style="color:red;">Paid Pending Penalty</th>
            <th class="text-right" style="color:red;">{{ number_format($invoice['paid_pending'], 2) }}</th>
        </tr>
        @endif
        <tr class="total-row">
            <th colspan="6" class="text-right">Grand Total</th>
            <th class="text-right">
                @php
                    $grandTotal = $invoice['payment_summary']['grand_total'];
                    if(isset($invoice['paid_pending']) && $invoice['paid_pending'] > 0){
                        $grandTotal += $invoice['paid_pending'];
                    }
                @endphp
                {{ number_format($grandTotal, 2) }}
            </th>
        </tr>
    </tfoot>
</table>

<!-- Transaction Details -->
@if(!empty($invoice['transaction_details']))
<table style="width:100%; border-collapse: collapse; margin-top:10px;">
    <tr>
        <th colspan="2" class="section-title" style="text-align:left;">Transaction Details</th>
    </tr>
    @foreach($invoice['transaction_details'] as $key => $value)
    <tr>
        <td style="padding:5px; width:30%; text-transform:capitalize;">{{ str_replace('_',' ', $key) }}</td>
        <td style="padding:5px;">{{ $value ?? '-' }}</td>
    </tr>
    @endforeach
</table>
@endif

<!-- Notes & Signature -->
<table class="no-border" style="margin-top:15px;">
    <tr>
        <td width="65%" style="vertical-align:top; padding-right:10px;">
            <strong>Notes:</strong><br>
            1. Handle all products carefully.<br>
            2. Follow storage and usage instructions.<br>
            3. Inspect items upon delivery.<br>
            4. Coordinate with your team for safe handling.<br>
            5. Retain this invoice as the official receipt for records.<br>
        </td>
        <td width="35%" class="signature" style="vertical-align:top; text-align:center;">
            <img src="{{ public_path('assets/images/logo.jpg') }}" alt="Signature" style="width:100%; height:150px;"><br>
            <strong>Authorized Signatory</strong>
        </td>
    </tr>
</table>

<!-- Footer Note -->
<div class="footer-note">
    Thank you for your purchase! We hope you are satisfied with our products. <br>Please consider leaving a review to help us improve our services.
</div>

</body>
</html>
