<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice #{{ $invoice['invoice_no'] }}</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; color: #000; margin:0; padding:0; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 10px; }
        th, td { border: 1px solid #000; padding: 6px; vertical-align: top; }
        th { background: #f2f2f2; text-align: center; }
        .no-border td, .no-border th { border: none !important; padding: 4px; }
        .header-logo img { width: 120px; height: auto; display:block; margin:0 auto; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .total-row { font-weight: bold; background:#f9f9f9; }
        .desc-box { line-height:1.3; word-break: break-word; }
        .signature { text-align:center; margin-top: 20px; }
        .invoice-label { text-align:center; font-size:14px; font-weight:bold; margin-bottom:5px; }
        a { color:#1a73e8; text-decoration:none; }
    </style>
</head>
<body>

<!-- Invoice Label -->
<!-- <p class="invoice-label">Original for Recipient</p> -->

<!-- Header -->
<table width="100%" border="1" cellspacing="0" cellpadding="10" style="border-collapse: collapse;">
    <tr>
        <!-- Logo -->
        <td width="30%" style="text-align:center; vertical-align:middle;">
            <img src="{{ public_path('assets/images/logo.jpg') }}" alt="Logo" style="width:180px; height:auto; display:block; margin:0 auto;">
        </td>

        <!-- Company Info -->
        <td style="padding-left:15px; vertical-align:middle;">
            <h2 style="margin:0; font-size:18px; color:#333;">Buildours</h2>
            <p style="margin:3px 0; font-size:12px; color:#555;">
                Location: Adavathur, Trichy<br>
                <a href="tel:+918148195967">+91 8148195967</a> | 
                <a href="mailto:buildoursapps@gmail.com">buildoursapps@gmail.com</a>

                <!-- <a href="https://buildoursapps.com" style="color:#1a73e8; text-decoration:none;">www.buildoursapps.com</a> -->
            </p>
        </td>

        <!-- Invoice Type + Original for Recipient -->
        <td width="20%" style="text-align:right; vertical-align:middle; font-size:22px; font-weight:bold; color:#333;">
            <div style="line-height:1.2;">
                TAX INVOICE<br>
                <span style="font-size:12px; font-weight:normal;">Original for Recipient</span>
            </div>
        </td>
    </tr>
</table>


<!-- Invoice & Order Details -->
<table style="width:100%; border-collapse: collapse; margin-bottom:15px;">
    <tr>
        <td width="50%" style="border:1px solid #000; padding:10px; background:#f9f9f9; vertical-align:top;">
            <h4 style="margin:0 0 5px 0; font-size:14px; color:#333;">Invoice Details</h4>
            <p style="margin:3px 0;"><strong>Invoice No:</strong> {{ $invoice['invoice_no'] }}</p>
            <p style="margin:3px 0;"><strong>Invoice Date:</strong> {{ \Carbon\Carbon::parse($invoice['invoice_date'])->format('d-m-Y') }}</p>
            <p style="margin:3px 0;"><strong>Payment Method:</strong> {{ $invoice['payment_summary']['payment_method'] }}</p>
        </td>
        <td width="50%" style="border:1px solid #000; padding:10px; background:#f9f9f9; vertical-align:top; text-align:right;">
            <h4 style="margin:0 0 5px 0; font-size:14px; color:#333;">Order Details</h4>
            <p style="margin:3px 0;"><strong>Order No:</strong> {{ $invoice['order_no'] }}</p>
            <p style="margin:3px 0;"><strong>Order Date:</strong> {{ \Carbon\Carbon::parse($invoice['order_date'])->format('d-m-Y') }}</p>
        </td>
    </tr>
</table>

<!-- Bill To / Ship To -->
<table>
    <tr>
        <th width="50%">Bill To</th>
        <th width="50%">Ship To</th>
    </tr>
    <tr>
        <td style="padding:8px;">
            <strong>{{ $invoice['delivery_address']['name'] }}</strong><br>
            {{ $invoice['delivery_address']['door_no'] }}, {{ $invoice['delivery_address']['street'] }}<br>
            {{ $invoice['delivery_address']['area'] }}, {{ $invoice['delivery_address']['city'] }}<br>
            {{ $invoice['delivery_address']['district'] }}, {{ $invoice['delivery_address']['state'] }} - {{ $invoice['delivery_address']['pincode'] }}<br>
            Phone: {{ $invoice['delivery_address']['phone'] }}
        </td>
        <td style="padding:8px;">
            <strong>{{ $invoice['delivery_address']['name'] }}</strong><br>
            {{ $invoice['delivery_address']['door_no'] }}, {{ $invoice['delivery_address']['street'] }}<br>
            {{ $invoice['delivery_address']['area'] }}, {{ $invoice['delivery_address']['city'] }}<br>
            {{ $invoice['delivery_address']['district'] }}, {{ $invoice['delivery_address']['state'] }} - {{ $invoice['delivery_address']['pincode'] }}<br>
            Phone: {{ $invoice['delivery_address']['phone'] }}
        </td>
    </tr>
</table>

<!-- Item Table -->
<table>
    <thead>
        <tr>
            <th>#</th>
            <th>Product</th>
            <th>Category</th>
            <th>Brand</th>
            <th>Qty</th>
            <th>Unit Price</th>
            <th>Total</th>
        </tr>
    </thead>
    <tbody>
        @foreach($invoice['materials'] as $index => $item)
        <tr>
            <td class="text-center">{{ $index + 1 }}</td>
            <td class="desc-box">
                @if($item['image'])
                    <img src="{{ public_path($item['image']) }}" width="60"><br>
                @endif
                {{ $item['subcategory'] ?? '' }} - {{ $item['category'] ?? '' }}
            </td>
            <td class="text-center">{{ $item['category'] ?? '' }}</td>
            <td class="text-center">{{ $item['brand'] ?? '' }}</td>
            <td class="text-center">{{ $item['quantity'] }} {{ $item['quantity_unit'] ?? '' }}</td>
            <td class="text-right">{{ number_format($item['unit_price'], 2) }}</td>
            <td class="text-right">{{ number_format($item['total_price'], 2) }}</td>
        </tr>
        @endforeach
    </tbody>
    <tfoot>
        <tr class="total-row">
            <th colspan="6" class="text-right">Delivery Charge</th>
            <th class="text-right">{{ number_format($invoice['payment_summary']['delivery_charge'],2) }}</th>
        </tr>
        @if(isset($invoice['paid_pending']) && $invoice['paid_pending'] > 0)
        <tr class="total-row">
            <th colspan="6" class="text-right" style="color:red;">Paid Pending Penalty</th>
            <th class="text-right" style="color:red;">{{ number_format($invoice['paid_pending'], 2) }}</th>
        </tr>
        @endif
        <tr class="total-row">
            <th colspan="6" class="text-right">Grand Total</th>
            <th class="text-right">
                @php
                    $grandTotal = $invoice['payment_summary']['grand_total'];
                    if(isset($invoice['paid_pending']) && $invoice['paid_pending'] > 0){
                        $grandTotal += $invoice['paid_pending'];
                    }
                @endphp
                {{ number_format($grandTotal, 2) }}
            </th>
        </tr>
    </tfoot>
</table>

<!-- Transaction Details -->
@if(!empty($invoice['transaction_details']))
<table style="width:100%; border-collapse: collapse; margin-top:10px;">
    <tr>
        <th colspan="2" style="text-align:left; background:#f2f2f2; padding:5px;">Transaction Details</th>
    </tr>
    @foreach($invoice['transaction_details'] as $key => $value)
    <tr>
        <td style="padding:5px; width:30%; text-transform:capitalize;">{{ str_replace('_',' ', $key) }}</td>
        <td style="padding:5px;">{{ $value ?? '-' }}</td>
    </tr>
    @endforeach
</table>
@endif

<!-- Notes & Signature -->
<table class="no-border" style="margin-top:15px;">
    <tr>
        <td width="65%" style="vertical-align:top; padding-right:10px;">
            <strong>Notes:</strong><br>
            1. Handle all products with care to avoid damage.<br>
            2. Ensure proper storage and handling according to product specifications.<br>
            3. Inspect items upon delivery and report any discrepancies immediately.<br>
            4. Coordinate with your team to ensure safe handling and proper usage.<br>
            5. Retain this invoice for records as it serves as the official receipt for the recipient.<br>
        </td>
        <td width="35%" class="signature" style="vertical-align:top; text-align:center;">
            <img src="{{ public_path('assets/images/logo.jpg') }}" alt="Signature" style="width:100%; height:150px;"><br>
            <strong>Authorized Signatory</strong>
        </td>
    </tr>
</table>
<!-- Footer Note -->
<div style="position:fixed; bottom:10px; width:100%; text-align:center; font-size:12px; color:#555;">
    Thank you for your purchase! We hope you are satisfied with our product. <br>Please consider leaving a review to help us improve our services.
</div>
</body>
</html>
