<?php

use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\UserController;
use App\Events\TestEvent;
use App\Http\Controllers\Admin\AdminAuthWebController;
use App\Http\Controllers\Admin\AdminDashboardController;
use App\Http\Controllers\StorePurchaseController;

Route::get(
    '/test/store/orders/{orderId}/invoice/pdf',
    [StorePurchaseController::class, 'downloadStoreOrderInvoicePdf']
);

Route::prefix('admin')->group(function () {

    // ---------- GUEST ----------
    Route::middleware('guest:admin')->group(function () {
        Route::get('/login', [AdminAuthWebController::class, 'showLogin'])->name('admin.login');
        Route::post('/login', [AdminAuthWebController::class, 'login'])->name('admin.login.submit');
    });

    // ---------- AUTH ----------
    Route::middleware('auth:admin')->group(function () {

        // Dashboard
        Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('admin.dashboard');
        Route::post('/logout', [AdminAuthWebController::class, 'logout'])->name('admin.logout');

        /* ===============================
           USER MANAGEMENT
        =============================== */

        // List users
        Route::get('/users/warehouses', [UserController::class, 'warehouses'])->name('admin.users.warehouses');
        Route::get('/users/stores', [UserController::class, 'stores'])->name('admin.users.stores');
        Route::get('/users/{type}/{id}', [UserController::class, 'show'])->whereIn('type', ['warehouse', 'store'])->name('admin.users.show');
        Route::post('/users/{type}/{id}/approve', [UserController::class, 'approve'])->whereIn('type', ['warehouse', 'store'])->name('admin.users.approve');
        Route::post('/users/{type}/{id}/reject', [UserController::class, 'reject'])->whereIn('type', ['warehouse', 'store'])->name('admin.users.reject');
        Route::post('/{type}/products/{id}/approve', [UserController::class, 'approveProduct'])->name('admin.products.approve');
        Route::post('/{type}/products/{id}/reject', [UserController::class, 'rejectProduct'])->name('admin.products.reject');
        Route::post('/users/{type}/{id}/bank/approve', [UserController::class, 'approveBank'])->name('admin.bank.approve');
        Route::post('/users/{type}/{id}/bank/reject', [UserController::class, 'rejectBank'])->name('admin.bank.reject');

        /* ===============================
           RIDER MANAGEMENT
        =============================== */

        Route::get('/users/riders', [UserController::class, 'riders'])->name('admin.riders.index');
        Route::get('/users/riders/{id}', [UserController::class, 'riderShow'])->name('admin.riders.show');
        Route::post('/users/riders/{id}/approve', [UserController::class, 'approveRider'])->name('admin.riders.approve');
        Route::post('/users/riders/{id}/reject', [UserController::class, 'rejectRider'])->name('admin.riders.reject');
        Route::post('/users/riders/{id}/rate/approve', [UserController::class, 'approveRate'])->name('admin.riders.rate.approve');
        Route::post('/users/riders/{id}/rate/reject', [UserController::class, 'rejectRate'])->name('admin.riders.rate.reject');

        Route::get('/users/customers', [UserController::class, 'customers'])->name('admin.customers.index');
        Route::get('/users/customers/{id}', [UserController::class, 'customerDetails'])->name('admin.customers.show');

        Route::patch('customers/{id}/block', [UserController::class, 'blockCustomer'])->name('admin.customers.block');
        Route::patch('customers/{id}/unblock', [UserController::class, 'unblockCustomer'])->name('admin.customers.unblock');


        /* ===============================
           PRODUCT MANAGEMENT
        =============================== */

        Route::get('/products', [ProductController::class, 'index'])->name('admin.products');
        Route::get('/products/create', [ProductController::class, 'create'])->name('admin.products.create');
        Route::post('/products', [ProductController::class, 'store'])->name('admin.products.store');
        Route::get('/products/{product}/edit', [ProductController::class, 'edit'])->name('admin.products.edit');
        Route::put('/products/{product}', [ProductController::class, 'update'])->name('admin.products.update');
        Route::patch('/products/{product}/pricing',[ProductController::class, 'updatePricing'])->name('admin.products.update-pricing');
        Route::delete('/products/{product}', [ProductController::class, 'destroy'])->name('admin.products.destroy');
        Route::get('/subcategories/by-category/{category}',[ProductController::class, 'getSubcategories'])->name('admin.subcategories.by-category');
        Route::get('/quantity-units/by-category/{category}', [ProductController::class, 'getByCategory'])->name('admin.quantity-units.by-category');
        Route::get('/brands/by-category/{category}', [ProductController::class, 'getBrandsByCategory']);

        /* ===============================
           CATEGORY MANAGEMENT
        =============================== */

        Route::get('/categories', [ProductController::class,'CategoryIndex'])->name('admin.categories.index');
        Route::post('/categories', [ProductController::class,'CategoryStore'])->name('admin.categories.store');
        Route::put('/categories/{category}', [ProductController::class, 'CategoryUpdate'])->name('admin.categories.update');
        Route::delete('/categories/{id}', [ProductController::class,'CategoryDestroy'])->name('admin.categories.destroy');

        /* ===============================
           SUBCATEGORY MANAGEMENT
        =============================== */

        Route::get('/subcategories', [ProductController::class, 'SubCategoryIndex'])->name('admin.subcategories.index');
        Route::post('/subcategories', [ProductController::class, 'SubCategoryStore'])->name('admin.subcategories.store');
        Route::put('/subcategories/{subcategory}', [ProductController::class, 'SubCategoryUpdate'])->name('admin.subcategories.update');
        Route::delete('/subcategories/{subcategory}', [ProductController::class, 'SubCategoryDestroy'])->name('admin.subcategories.destroy');

        /* ===============================
           QUANTITY UNIT MANAGEMENT
        =============================== */

        Route::get('/quantity-units', [ProductController::class, 'QuantityUnitIndex'])->name('admin.quantity-units.index');
        Route::post('/quantity-units', [ProductController::class, 'QuantityUnitStore'])->name('admin.quantity-units.store');
        Route::put('/quantity-units/{quantityUnit}', [ProductController::class, 'QuantityUnitUpdate'])->name('admin.quantity-units.update');
        Route::delete('/quantity-units/{quantityUnit}', [ProductController::class, 'QuantityUnitDestroy'])->name('admin.quantity-units.destroy');

        /* ===============================
           BRAND MANAGEMENT
        =============================== */

        Route::get('/brands', [ProductController::class,'BrandIndex'])->name('admin.brands.index');
        Route::post('/brands', [ProductController::class,'BrandStore'])->name('admin.brands.store');
        Route::put('/brands/{brand}', [ProductController::class,'BrandUpdate'])->name('admin.brands.update');
        Route::delete('/brands/{brand}', [ProductController::class,'BrandDestroy'])->name('admin.brands.destroy');


        Route::get('/product-reviews', [ProductController::class, 'reviewIndex'])->name('admin.product-reviews.index');
        Route::post('/product-reviews/{id}/toggle', [ProductController::class, 'reviewStatus'])->name('admin.product-reviews.toggle');


        Route::get('/orders', [OrderController::class, 'index'])->name('admin.orders.index');
        Route::get('/orders/{id}', [OrderController::class, 'show'])->name('admin.orders.show');


         Route::get('/delivery-prices', [UserController::class, 'deliveryIndex'])->name('admin.delivery.index');
         Route::post('/delivery-prices', [UserController::class, 'deliveryStore'])->name('admin.delivery.store');
         Route::put('/delivery-prices/{id}', [UserController::class, 'deliveryUpdate'])->name('admin.delivery.update');
         Route::delete('/delivery-prices/{id}', [UserController::class, 'deliveryDestroy'])->name('admin.delivery.destroy');


    });
});

