

<?php $__env->startSection('title', ' Rider Details'); ?>

<?php $__env->startSection('styles'); ?>
<style>
/* ===============================
   DETAIL PAGE STYLING
=============================== */
.card {
    border: none;
    border-radius: 12px;
    box-shadow: 0 8px 20px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
}
.card-header {
    background: linear-gradient(to bottom, #29B2F6, #5AF399);
    color: #fff;
    font-weight: 600;
    font-size: 1.1rem;
    border-top-left-radius: 12px;
    border-top-right-radius: 12px;
}
.detail-row {
    margin-bottom: 1rem;
}
.detail-label {
    font-weight: 600;
    color: #374151;
}
.detail-value {
    color: #111827;
}
.status-badge {
    padding: 6px 16px;
    border-radius: 30px;
    font-weight: 600;
    font-size: 0.9rem;
}
.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-pending { background: #fff5e5; color: #d48806; }
.status-rejected { background: #fdecea; color: #c62828; }

.btn-back {
    background: #f0f4f8;
    color: #10171d;
    font-weight: 500;
    border-radius: 8px;
}
.action-btn {
    padding: 10px 24px;
    border-radius: 8px;
    font-weight: 600;
    margin-right: 12px;
    border: none;
}
.action-approve { background: #22c55e; color: #fff; }
.action-reject { background: #ef4444; color: #fff; }
.modal-header {
    background: linear-gradient(to bottom, #29B2F6, #5AF399);
    color: #fff;
}

.modal-dialog {
    margin-left: auto !important;
    margin-right: auto !important;
    justify-content: center !important;
}

.modal {
    padding-right: 0 !important;
}

th{
    text-align: center;
}


</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">Rider Details</h3>
        <a href="<?php echo e(route('admin.riders.index')); ?>" class="btn btn-outline-secondary btn-sm">
            ← Back to Riders
        </a>
    </div>

    <!-- Approve / Reject Rider -->
    <?php if($rider->status === 'pending_admin'): ?>
        <div class="mb-4">
            <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#approveModal">
                Approve
            </button>
            <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#rejectModal">
                Reject
            </button>
        </div>
    <?php endif; ?>

    <!-- General Information -->
    <div class="card mb-4">
        <div class="card-header">General Information</div>
        <div class="card-body">

            <div class="text-center mb-3">
                <?php if($rider->logo && file_exists(public_path($rider->logo))): ?>
                    <img src="<?php echo e(asset($rider->logo)); ?>" class="img-fluid rounded" style="max-height:120px;">
                <?php else: ?>
                    <span class="text-muted">No photo uploaded</span>
                <?php endif; ?>
            </div>

            <div class="row mb-2">
                <div class="col-md-6"><strong>Name:</strong> <?php echo e($rider->name); ?></div>
                <div class="col-md-6"><strong>Rider Code:</strong> <?php echo e($rider->rider_code ?? 'N/A'); ?></div>
            </div>

            <div class="row mb-2">
                <div class="col-md-6"><strong>Email:</strong> <?php echo e($rider->email); ?></div>
                <div class="col-md-6"><strong>Mobile:</strong> <?php echo e($rider->mobile_number); ?></div>
            </div>

            <div class="row mb-2">
                <div class="col-md-6">
                    <strong>Status:</strong>
                    <span class="badge
                        <?php echo e($rider->status === 'active' ? 'bg-success' :
                           ($rider->status === 'pending_admin' ? 'bg-warning' : 'bg-danger')); ?>">
                        <?php echo e(ucfirst(str_replace('_',' ',$rider->status))); ?>

                    </span>
                </div>
                <div class="col-md-6"><strong>Vehicle Type:</strong> <?php echo e($rider->vehicle_type); ?></div>
            </div>
        </div>
    </div>

    <!-- Vehicle & Legal -->
    <div class="card mb-4">
        <div class="card-header">Vehicle & Legal Information</div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <p><strong>Vehicle Number:</strong> <?php echo e($rider->vehicle_number); ?></p>
                    <p><strong>Driving License:</strong> <?php echo e($rider->driving_license_no); ?></p>
                </div>
                <div class="col-md-6">
                    <p><strong>RC Book:</strong> <?php echo e($rider->rc_book_no); ?></p>
                    <p><strong>PAN:</strong> <?php echo e($rider->pan_number ?? 'N/A'); ?></p>
                    <p><strong>Aadhaar:</strong> <?php echo e($rider->aadhar_number ?? 'N/A'); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Rate Information -->
    <div class="card mb-4">
        <div class="card-header">Rate Information</div>
        <div class="card-body">

            <div class="row">
                <div class="col-md-4">
                    <p><strong>Range:</strong> <?php echo e($rider->range ?? 'N/A'); ?> km</p>
                </div>

                <div class="col-md-4">
                    <p><strong>Rate / KM:</strong> ₹<?php echo e(number_format($rider->ratePerKm, 2)); ?></p>
                </div>

                <div class="col-md-4">
                    <p>
                        <strong>Status:</strong>
                        <span class="badge
                            <?php echo e($rider->rate_change_status === 'approved' ? 'bg-success' :
                            ($rider->rate_change_status === 'pending' ? 'bg-warning' : 'bg-danger')); ?>">
                            <?php echo e(ucfirst($rider->rate_change_status)); ?>

                        </span>
                    </p>
                </div>
            </div>

            
            <?php if($rider->rate_change_status === 'pending'): ?>
                <div class="mt-3">
                    <button class="btn btn-success btn-sm"
                            data-bs-toggle="modal"
                            data-bs-target="#rateApproveModal"
                            data-id="<?php echo e($rider->id); ?>">
                        Approve Rate
                    </button>

                    <button class="btn btn-danger btn-sm"
                            data-bs-toggle="modal"
                            data-bs-target="#rateRejectModal"
                            data-id="<?php echo e($rider->id); ?>">
                        Reject Rate
                    </button>
                </div>
            <?php endif; ?>

        </div>
    </div>


    <!-- Address -->
    <div class="card mb-4">
        <div class="card-header">Address</div>
        <div class="card-body">
            <?php echo e($rider->door_no); ?>,
            <?php echo e($rider->street_name); ?>,
            <?php echo e($rider->area); ?>,
            <?php echo e($rider->city); ?>,
            <?php echo e($rider->district->name ?? 'N/A'); ?>,
            <?php echo e($rider->state->name ?? 'N/A'); ?> -
            <?php echo e($rider->pincode); ?>,
            <?php echo e($rider->country); ?>

        </div>
    </div>

    <!-- Bank Information -->
    <div class="card">
        <div class="card-header">Bank Information</div>
        <div class="card-body">

            <div class="row">
                <!-- Approved Bank Details -->
                <div class="col-md-6">
                    <h6>Approved Bank Details</h6>
                    <p><strong>Account Holder:</strong> <?php echo e($rider->bank_holder_name); ?></p>
                    <p><strong>Bank:</strong> <?php echo e($rider->bank->name ?? 'N/A'); ?></p>
                    <p><strong>Account:</strong> <?php echo e($rider->bank_account_number); ?></p>
                    <p><strong>IFSC:</strong> <?php echo e($rider->ifsc_code); ?></p>
                    <p><strong>MICR:</strong> <?php echo e($rider->micr_no ?? 'N/A'); ?></p>
                    <p><strong>UPI:</strong> <?php echo e($rider->upi_id ?? 'N/A'); ?></p>
                    <p>
                        <strong>Passbook:</strong>
                        <?php if($rider->passbook_file && file_exists(public_path($rider->passbook_file))): ?>
                            <a href="<?php echo e(asset($rider->passbook_file)); ?>" target="_blank">View</a>
                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </p>
                </div>

                <!-- Pending Bank Update -->
                <?php
                    $pending = is_array($rider->pending_bank_data) ? $rider->pending_bank_data : json_decode($rider->pending_bank_data, true);
                ?>

                <?php if(!empty($pending)): ?>
                <div class="col-md-6">
                    <h6>Pending Update</h6>
                    <p><strong>Account Holder:</strong> <?php echo e($pending['bank_holder_name']); ?></p>
                    <p><strong>Bank:</strong> <?php echo e(\App\Models\Bank::find($pending['bank_id'])->name ?? 'N/A'); ?></p>
                    <p><strong>Account:</strong> <?php echo e($pending['bank_account_number']); ?></p>
                    <p><strong>IFSC:</strong> <?php echo e($pending['ifsc_code']); ?></p>
                    <p><strong>MICR:</strong> <?php echo e($pending['micr_no'] ?? 'N/A'); ?></p>
                    <p><strong>UPI:</strong> <?php echo e($pending['upi_id'] ?? 'N/A'); ?></p>
                    <p>
                        <strong>Passbook:</strong>
                        <?php if(!empty($pending['passbook_file']) && file_exists(public_path($pending['passbook_file']))): ?>
                            <a href="<?php echo e(asset($pending['passbook_file'])); ?>" target="_blank">View</a>
                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </p>

                    <div class="mt-3">
                        <button
                            class="btn btn-success btn-sm bank-approve-btn"
                            data-bs-toggle="modal"
                            data-bs-target="#bankApproveModal"
                            data-id="<?php echo e($rider->id); ?>"
                            data-type="<?php echo e($type); ?>">
                            Approve Bank
                        </button>

                        <button
                            class="btn btn-danger btn-sm bank-reject-btn"
                            data-bs-toggle="modal"
                            data-bs-target="#bankRejectModal"
                            data-id="<?php echo e($rider->id); ?>"
                            data-type="<?php echo e($type); ?>">
                            Reject Bank
                        </button>
                    </div>

                    <?php if($rider->admin_remark): ?>
                    <span class="text-muted mt-2 d-block">
                        Admin Remark: <?php echo e($rider->admin_remark); ?>

                    </span>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

</div>


<div class="modal fade" id="approveModal">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="<?php echo e(route('admin.riders.approve', $rider->id)); ?>">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header bg-success text-white justify-content-center">
                    <h5 class="modal-title">Approve Rider</h5>
                </div>
                <div class="modal-body text-center">
                    Are you sure you want to approve this rider?
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Approve</button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="modal fade" id="rejectModal">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="<?php echo e(route('admin.riders.reject', $rider->id)); ?>">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header bg-danger text-white justify-content-center">
                    <h5 class="modal-title">Reject Rider</h5>
                </div>
                <div class="modal-body">
                    <textarea name="admin_remark" class="form-control" rows="4" required
                              placeholder="Reason for rejection"></textarea>
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Reject</button>
                </div>
            </div>
        </form>
    </div>
</div>



<div class="modal fade" id="bankApproveModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="">
            <?php echo csrf_field(); ?>
            <div class="modal-content rounded-4 shadow-sm">
                <div class="modal-header bg-success text-white justify-content-center">
                    <h5 class="modal-title text-center">
                        Approve Bank Details
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center py-4">
                    Are you sure you want to approve the bank details request?
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary px-4" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success px-4">Approve</button>
                </div>
            </div>
        </form>
    </div>
</div>



<div class="modal fade" id="bankRejectModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="">
            <?php echo csrf_field(); ?>
            <div class="modal-content rounded-4 shadow-sm">
                <div class="modal-header bg-danger text-white justify-content-center">
                    <h5 class="modal-title text-center">Reject Bank Details</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center py-4">
                    Are you sure you want to reject the bank details request?
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary px-4" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger px-4">Reject</button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="modal fade" id="rateApproveModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="">
            <?php echo csrf_field(); ?>
            <div class="modal-content rounded-4 shadow-sm">
                <div class="modal-header bg-success text-white justify-content-center">
                    <h5 class="modal-title">Approve Rate Change</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center py-4">
                    Are you sure you want to approve this rate change?
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Approve</button>
                </div>
            </div>
        </form>
    </div>
</div>



<div class="modal fade" id="rateRejectModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="">
            <?php echo csrf_field(); ?>
            <div class="modal-content rounded-4 shadow-sm">
                <div class="modal-header bg-danger text-white justify-content-center">
                    <h5 class="modal-title">Reject Rate Change</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <!-- <div class="modal-body">
                    <textarea name="admin_remark" class="form-control" rows="4" required
                              placeholder="Reason for rejection"></textarea>
                </div> -->
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Reject</button>
                </div>
            </div>
        </form>
    </div>
</div>


<script>
document.addEventListener('DOMContentLoaded', function () {

    const bankApproveModal = document.getElementById('bankApproveModal');
    bankApproveModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const id = button.getAttribute('data-id');
        const type = button.getAttribute('data-type');
        const form = bankApproveModal.querySelector('form');
        form.action = `/admin/users/${type}/${id}/bank/approve`;
    });

    const bankRejectModal = document.getElementById('bankRejectModal');
    bankRejectModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const id = button.getAttribute('data-id');
        const type = button.getAttribute('data-type');
        const form = bankRejectModal.querySelector('form');
        form.action = `/admin/users/${type}/${id}/bank/reject`;
    });

    const rateApproveModal = document.getElementById('rateApproveModal');
    rateApproveModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const id = button.getAttribute('data-id');
        const form = rateApproveModal.querySelector('form');
        form.action = `/admin/users/riders/${id}/rate/approve`;
    });

    const rateRejectModal = document.getElementById('rateRejectModal');
    rateRejectModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const id = button.getAttribute('data-id');
        const form = rateRejectModal.querySelector('form');
        form.action = `/admin/users/riders/${id}/rate/reject`;
    });

});


</script>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Freshora\Laravel\buildours\resources\views/admin/riders/show.blade.php ENDPATH**/ ?>