

<?php $__env->startSection('title', 'Order Management'); ?>

<?php $__env->startSection('styles'); ?>
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet">

<style>
/* ===============================
   DATATABLE HEADER (FIXED)
=============================== */
.dataTables_wrapper table.dataTable thead th {
    background: linear-gradient(to bottom, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: .05em;
    text-align: center;
    border: none !important;
}

.dataTables_wrapper table.dataTable thead tr {
    background: none !important;
}

/* Rounded header */
.dataTables_wrapper table.dataTable thead th:first-child {
    border-top-left-radius: 12px;
}
.dataTables_wrapper table.dataTable thead th:last-child {
    border-top-right-radius: 12px;
}

/* Space below search bar */
.dataTables_wrapper .dataTables_filter {
    margin-bottom: 16px;
}

/* Space above table */
.dataTables_wrapper table.dataTable {
    margin-top: 12px !important;
}

/* ===============================
   TABLE BODY
=============================== */
table.dataTable tbody td {
    font-size: 14px;
    color: #374151;
    border-top: 1px solid #eef2f6;
    text-align: center;
}

/* Zebra rows */
table.dataTable tbody tr:nth-child(odd) {
    background-color: #f8fbff;
}
table.dataTable tbody tr:nth-child(even) {
    background-color: #ffffff;
}

/* ===============================
   ANIMATED ROW HOVER (PRO)
=============================== */
table.dataTable tbody tr {
    transition: all 0.25s ease;
}

table.dataTable tbody tr:hover {
    background-color: #e9f6ff !important;
    /* transform: scale(1.01); */
    box-shadow: 0 6px 18px rgba(41,178,246,.15);
    z-index: 2;
    position: relative;
}

/* ===============================
   SCROLLABLE TABLE
=============================== */
.table-responsive {
    overflow-x: auto !important;
}

/* ===============================
   STATUS BADGES
=============================== */
.status {
    padding: 6px 16px;
    font-size: 12px;
    font-weight: 600;
    border-radius: 30px;
    display: inline-block;
}

.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-inactive { background: #fdecea; color: #c62828; }

/* ===============================
   ACTION BUTTONS
=============================== */
.action-btn {
    border: none;
    background: none;
    font-size: 20px;
    margin: 0 6px;
    cursor: pointer;
}
.action-edit { color: #f59e0b; }

/* ===========================
   MODAL DESIGN
=========================== */

/* ===========================
   MODAL PERFECT ALIGNMENT
=========================== */

/* Ensure modal-dialog centers properly */
.modal-dialog {
    max-width: 500px; /* responsive max width */
    width: 90%;
    justify-content: center !important;
}

/* Modal content style */
.modal-content {
    border-radius: 1rem;
    overflow: hidden;
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}

/* Modal header */
.modal-header {
    padding: 1rem 1.5rem;
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
}

/* Modal body with scroll if content is tall */
.modal-body {
    max-height: 60vh;
    overflow-y: auto;
    padding: 1.5rem;
}

/* Inputs styling */
.modal-body .form-control,
.modal-body .form-select {
    box-shadow: none;
    border: 1px solid #ced4da;
    transition: 0.2s;
}

.modal-body .form-control:focus,
.modal-body .form-select:focus {
    border-color: #29b2f6;
    box-shadow: 0 0 5px rgba(41,178,246,0.3);
    outline: none;
}

/* Modal footer */
.modal-footer {
    display: flex;
    justify-content: space-between;
    padding: 0.75rem 1.5rem;
    border-top: none;
    background: #f9f9f9;
}

/* Buttons hover effect */
.modal-footer .btn:hover {
    transform: translateY(-2px);
    transition: 0.2s;
}

/* Scrollbar inside modal */
.modal-body::-webkit-scrollbar {
    width: 6px;
}

.modal-body::-webkit-scrollbar-thumb {
    background: rgba(41,178,246,0.5);
    border-radius: 10px;
}

.modal-body::-webkit-scrollbar-track {
    background: transparent;
}

/* Active page button */
.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    border: none !important;
    border-radius: 8px !important;
    box-shadow: 0 4px 10px rgba(41,178,246,.35);
}

/* ===============================
   MODERN ICON BUTTONS
=============================== */
.icon-btn {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    border: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    background: #f1f5f9;
    cursor: pointer;
    transition: all 0.2s ease;
}

.icon-btn i {
    font-size: 15px;
}

/* Edit */
.edit-btn {
    color: #0d6efd;
}
.edit-btn:hover {
    background: rgba(13,110,253,.15);
    transform: translateY(-2px);
}

/* Delete */
.delete-btn {
    color: #dc3545;
}
.delete-btn:hover {
    background: rgba(220,53,69,.15);
    transform: translateY(-2px);
}

.btn-add {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-radius: 20px;
    padding: 8px 20px;
    font-weight: 600;
    border: none;
    text-decoration: none;
}
.btn-back {
    background: #f1f5f9;
    color: #374151;
    border-radius: 20px;
    padding: 8px 20px;
    font-weight: 600;
    border: 1px solid;
    transition: all .2s ease;
    text-decoration: none;
}

.btn-back:hover {
    background: #e2e8f0;
}


/* Buyer / Seller box */
.user-box{
    background:#f9fafb;
    padding:8px 10px;
    border-radius:10px;
    text-align:center;
}
.user-name{
    font-size:13px;
    font-weight:600;
}
.user-type{
    font-size:11px;
    padding:2px 10px;
    border-radius:20px;
    margin-top:4px;
    font-weight:600;
    display:inline-block;
    text-transform:uppercase;
}
.user-type.customer{
    background:#e0f2fe;
    color:#075985;
}
.user-type.store{
    background:#ecfdf5;
    color:#065f46;
}
.user-type.warehouse{
    background:#fef3c7;
    color:#92400e;
}

/* Order No */
.order-box{
    background:#0f172a;
    color:#fff;
    padding:6px 12px;
    border-radius:10px;
    font-size:13px;
    font-weight:600;
    display:inline-block;
}

/* Status box */
.status-box{
    background:#f8fafc;
    padding:8px 10px;
    border-radius:10px;
    text-align:center;
}
.status-time{
    font-size:11px;
    color:#6b7280;
    margin-top:4px;
}

/* Shipping badge */
.shipping-badge{
    font-size:12px;
    font-weight:600;
    padding:6px 14px;
    border-radius:20px;
}
.shipping-yes{
    background:#ecfdf5;
    color:#047857;
}
.shipping-no{
    background:#f1f5f9;
    color:#475569;
}

/* Payment box */
.payment-box{
    background:#f8fafc;
    padding:8px 10px;
    border-radius:10px;
    text-align:center;
}
.payment-method{
    font-size:12px;
    font-weight:600;
}
.payment-status{
    font-size:11px;
    color:#6b7280;
}

/* Rider box */
.rider-box{
    background:#f8fafc;
    padding:8px 10px;
    border-radius:10px;
    text-align:center;
}
.rider-code{
    font-weight:700;
    font-size:13px;
    letter-spacing:1px;
}

/* Total */
.total-box{
    font-weight:700;
    color:#0f172a;
}

.status-pending_assignment { background:#fff7ed; color:#c2410c; }
.status-order_taken { background:#eef2ff; color:#3730a3; }
.status-in_transit { background:#ecfeff; color:#0369a1; }
.status-completed { background:#ecfdf5; color:#047857; }
.status-cancelled { background:#fef2f2; color:#b91c1c; }
.status-rider_accepted { background:#eff6ff; color:#1d4ed8; }
.status-rider_verified { background:#f0fdf4; color:#166534; }

.soldby-box{
    padding:6px 10px;
    border-radius:10px;
    transition:0.2s;
}

.soldby-box:hover{
    background:#f5f7fb;
    transform: translateY(-1px);
}


</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">Order Management</h3>

        <div class="d-flex gap-2">
            <a href="<?php echo e(route('admin.dashboard')); ?>"
               class="btn-back d-flex align-items-center">
                <i class="fa fa-arrow-left me-2"></i> Dashboard
            </a>
        </div>
    </div>

    <div class="card border-0 shadow-lg rounded-4">
        <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
            <div class="fw-semibold">Orders List</div>
            <div style="width:220px">
                <small class="text-muted">Filter by Order Status:</small>
                <select id="statusFilter" class="form-select form-select-sm">
                    <option value="">All Status</option>
                    <option value="pending_assignment">Pending Assignment</option>
                    <!-- <option value="pending_payment">Pending Payment</option> -->
                    <option value="order_taken">Order Taken</option>
                    <option value="waiting_for_rider_approval">Waiting For Rider Approval</option>
                    <option value="rider_accepted">Rider Accepted</option>
                    <option value="rider_verified">Rider Verified</option>
                    <option value="in_transit">In Transit</option>
                    <option value="completed">Completed</option>
                    <option value="cancelled">Cancelled</option>
                </select>
            </div>
        </div>
        <div class="card-body">
            <?php if(request('status')): ?>
                <div class="alert alert-info py-2 mb-3">
                    Showing orders with status:
                    <strong><?php echo e(ucwords(str_replace('_',' ', request('status')))); ?></strong>
                    <a href="<?php echo e(route('admin.orders.index')); ?>" class="ms-2 text-decoration-none">
                        Clear filter
                    </a>
                </div>
            <?php endif; ?>
            <div class="table-responsive">
                <table id="common-table" class="display dataTable w-100">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Order</th>
                            <th>Seller</th>
                            <th>Customer</th>
                            <th>Amount</th>
                            <th>Shipping</th>
                            <th>Status</th>
                            <th>Payment</th>
                            <th>Rider</th>
                            <th>Action</th>
                            <th style="display:none">Created</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($i + 1); ?></td>

                            <td style="text-align:left">
                                <div class="fw-semibold"><?php echo e($order->order_no); ?></div>
                                <!-- <small class="text-muted">
                                    <?php echo e($order->created_at->format('d M Y, h:i A')); ?>

                                </small> -->
                            </td>

                            <td>
                                <?php if($order->approved_by && $order->approved_by_user_type): ?>

                                    <?php
                                        $type = $order->approved_by_user_type; // warehouse | store
                                        $id   = $order->approved_by;
                                    ?>

                                    <a href="<?php echo e(route('admin.users.show', ['type' => $type, 'id' => $id])); ?>"
                                    class="text-decoration-none d-flex flex-column soldby-box">

                                        <div class="fw-semibold text-dark soldby-name">
                                            <?php echo e($order->sellerName()); ?>

                                        </div>

                                        <div class="soldby-type <?php echo e($type); ?>">
                                            <?php echo e($type); ?>

                                        </div>
                                    </a>

                                <?php else: ?>
                                    <div class="fw-semibold text-dark">N/A</div>
                                <?php endif; ?>
                            </td>

                            <td>
                                <?php
                                    $type = $order->user_type; // customer | store
                                    $id   = $order->user_id;
                                ?>

                                <?php if($type && $id): ?>
                                    <a href="<?php echo e(route('admin.users.show', ['type' => $type, 'id' => $id])); ?>"
                                    class="text-decoration-none d-flex flex-column soldby-box">

                                        <div class="fw-semibold text-dark soldby-name">
                                            <?php echo e($order->buyerName()); ?>

                                        </div>

                                        <div class="soldby-type <?php echo e($type); ?>">
                                            <?php echo e($type); ?>

                                        </div>
                                    </a>
                                <?php else: ?>
                                    <div class="fw-semibold text-dark">N/A</div>
                                <?php endif; ?>
                            </td>

                            <td>
                                <div class="fw-semibold">₹<?php echo e(number_format($order->grand_total, 2)); ?></div>
                                <!-- <?php if($order->with_shipping): ?>
                                    <small class="text-success fw-semibold">
                                        + Shipping
                                    </small>
                                <?php else: ?>
                                    <small class="text-muted">
                                        No Shipping
                                    </small>
                                <?php endif; ?> -->
                            </td>

                            <td>
                                <span class="status <?php echo e($order->with_shipping ? 'status-active' : 'status-inactive'); ?>">
                                    <?php echo e($order->with_shipping ? 'Yes' : 'No'); ?>

                                </span>
                            </td>

                            <td>
                                <span class="status status-<?php echo e($order->status); ?>">
                                    <?php echo e(ucwords(str_replace('_',' ', $order->status))); ?>

                                </span>

                                <!-- <?php if($order->statusTime()): ?>
                                    <div class="text-muted small">
                                        <?php echo e($order->statusTime()->format('d M Y, h:i A')); ?>

                                    </div>
                                <?php endif; ?> -->
                            </td>

                            <td>
                                <div class="fw-semibold">
                                    <?php echo e($order->payment_method ?? 'N/A'); ?>

                                </div>
                                <small class="text-muted">
                                    <?php echo e(ucfirst($order->payment_status)); ?>

                                </small>
                            </td>

                            <td>
                                <?php if($order->rider): ?>
                                    <a href="<?php echo e(route('admin.riders.show', $order->rider->id)); ?>"
                                    class="text-decoration-none d-flex flex-column soldby-box">

                                        <div class="fw-semibold text-dark soldby-name">
                                            <?php echo e($order->rider->rider_code); ?>

                                        </div>

                                        <!-- <div class="soldby-type rider">
                                            rider
                                        </div> -->
                                    </a>
                                <?php else: ?>
                                    <div class="fw-semibold text-muted">Not Assigned</div>
                                <?php endif; ?>
                            </td>


                            <td class="text-center gap-1">
                                <a href="#"
                                class="icon-btn edit-btn"
                                title="View Order">
                                    <i class="fa-solid fa-eye"></i>
                                </a>

                                <!-- <a href="#"
                                class="icon-btn edit-btn"
                                title="Invoice">
                                    <i class="fa-solid fa-file-invoice"></i>
                                </a> -->

                                <button class="icon-btn delete-btn"
                                    data-bs-toggle="modal"
                                    data-bs-target="#deleteModal"
                                    data-id="<?php echo e($order->id); ?>"
                                    data-name="<?php echo e($order->order_no); ?>"
                                    title="Delete Order">
                                    <i class="fa-solid fa-trash"></i>
                                </button>
                            </td>
                            <td style="display:none"><?php echo e($order->created_at->timestamp); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
$(document).ready(function () {

    let table = $('#common-table').DataTable({
        pageLength: 10,
        order: [[10, 'desc']],
        columnDefs: [
            { orderable: false, targets: [0, 9] },
            { visible: false, targets: [10] },
            { responsivePriority: 1, targets: 0 },
            { responsivePriority: 2, targets: 1 },
            { responsivePriority: 3, targets: 7 },
            { responsivePriority: 4, targets: 9 },
            { responsivePriority: 5, targets: 4 },
            { targets: [5, 8], className: 'none' }
        ],
        responsive: true
    });

    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    $('#statusFilter').on('change', function () {
        let value = $(this).val();
        if (value === "") {
            table.column(6).search('').draw(); // All statuses
        } else {
            let label = value.replaceAll('_', ' '); // Convert pending_assignment → pending assignment
            table.column(6).search(label, true, false).draw();
        }
    });

});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Freshora\Laravel\buildours\resources\views/admin/orders/index.blade.php ENDPATH**/ ?>