

<?php $__env->startSection('title', 'Category Management'); ?>

<?php $__env->startSection('styles'); ?>
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet">

<style>
/* ===============================
   DATATABLE HEADER
=============================== */
.dataTables_wrapper table.dataTable thead th {
    background: linear-gradient(to bottom, #29B2F6, #5AF399) !important;
    color: #fff !important;
    font-size: 13px;
    font-weight: 600;
    text-transform: uppercase;
    text-align: center;
    border: none !important;
}

.dataTables_wrapper table.dataTable thead th:first-child {
    border-top-left-radius: 12px;
}
.dataTables_wrapper table.dataTable thead th:last-child {
    border-top-right-radius: 12px;
}

.dataTables_wrapper table.dataTable {
    margin-top: 12px !important;
}

.dataTables_wrapper .dataTables_filter {
    margin-bottom: 16px;
}

/* ===============================
   TABLE BODY
=============================== */
table.dataTable tbody td {
    text-align: center;
    font-size: 14px;
    border-top: 1px solid #eef2f6;
}

table.dataTable tbody tr:nth-child(odd) {
    background: #f8fbff;
}
table.dataTable tbody tr:nth-child(even) {
    background: #fff;
}

table.dataTable tbody tr {
    transition: all .25s ease;
}
table.dataTable tbody tr:hover {
    background: #e9f6ff !important;
    box-shadow: 0 6px 18px rgba(41,178,246,.15);
}

/* Active page button */
.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    border: none !important;
    border-radius: 8px !important;
    box-shadow: 0 4px 10px rgba(41,178,246,.35);
}
/* ===============================
   ICON ACTION BUTTONS (FIXED)
=============================== */
.icon-btn {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    border: none;
    background: #f1f5f9;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all .2s ease;
}

.icon-btn i {
    font-size: 15px;
}

/* EDIT */
.approve-btn {
    color: #0d6efd !important;
}
.approve-btn:hover {
    background: rgba(13,110,253,.15);
    transform: translateY(-2px);
}

/* DELETE */
.reject-btn {
    color: #ef4444 !important;
}
.reject-btn:hover {
    background: rgba(239,68,68,.15);
    transform: translateY(-2px);
}


/* ===============================
   ADD BUTTON
=============================== */
.btn-add {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-radius: 20px;
    padding: 8px 20px;
    font-weight: 600;
    border: none;
}

/* ===============================
   MODAL FIX (CENTERED & CLEAN)
=============================== */
.modal {
    overflow-y: auto;
    padding-right: 0 !important;
}

.modal-dialog {
    margin: auto !important;
    max-width: 500px;
    justify-content: center !important;
}

.modal-content {
    border-radius: 14px;
    border: none;
    box-shadow: 0 15px 40px rgba(0,0,0,.15);
}

.modal-header {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-top-left-radius: 14px;
    border-top-right-radius: 14px;
}

.modal-footer .btn {
    border-radius: 20px;
}

/* ===============================
   INPUTS
=============================== */
.form-control {
    border-radius: 10px;
}

/* ===============================
   MOBILE FIX
=============================== */
@media (max-width: 768px) {
    .table-responsive {
        overflow-x: auto;
    }
    table.dataTable {
        min-width: 700px;
    }
}

.status {
    padding: 6px 16px;
    font-size: 12px;
    font-weight: 600;
    border-radius: 30px;
    display: inline-block;
}

.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-inactive { background: #fdecea; color: #c62828; }
</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">Category Management</h3>
        <button class="btn-add"
                data-bs-toggle="modal"
                data-bs-target="#addCategoryModal">
            <i class="fa fa-plus me-2"></i> Add Category
        </button>

    </div>

    
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table id="category-table" class="display w-100">
                    <thead>
                        <tr>
                            <th>S.no</th>
                            <th>Image</th>
                            <th>Category Name</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td>
                                <?php if($category->image): ?>
                                    <img src="<?php echo e(asset($category->image)); ?>"
                                        width="50" height="50"
                                        class="rounded"
                                        style="object-fit:cover">
                                <?php else: ?>
                                    <span class="text-muted">No Image</span>
                                <?php endif; ?>
                            </td>

                            <td class="fw-semibold"><?php echo e($category->name); ?></td>
                            <td>
                                <span class="status status-<?php echo e($category->status); ?>">
                                    <?php echo e(ucfirst($category->status)); ?>

                                </span>
                            </td>
                            <td>
                                <button class="icon-btn approve-btn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#editCategoryModal"
                                        data-id="<?php echo e($category->id); ?>"
                                        data-name="<?php echo e($category->name); ?>"
                                        data-status="<?php echo e($category->status); ?>">
                                    <i class="fa fa-pen"></i>
                                </button>


                                <button class="icon-btn reject-btn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#deleteCategoryModal"
                                        data-id="<?php echo e($category->id); ?>"
                                        data-name="<?php echo e($category->name); ?>">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="addCategoryModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="<?php echo e(route('admin.categories.store')); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Add Category</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="detail-label mb-1">Category Name</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="detail-label mb-1">Category Image</label>
                        <input type="file" name="image" class="form-control" accept="image/*">
                    </div>

                </div>
                <div class="modal-footer">
                    <button class="btn btn-success px-4">Save</button>
                    <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="modal fade" id="editCategoryModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="editCategoryForm"  enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Edit Category</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="detail-label mb-1">Category Name</label>
                        <input type="text" name="name" id="editCategoryName"
                            class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="detail-label mb-1">Category Image</label>
                        <input type="file" name="image" class="form-control" accept="image/*">
                    </div>


                    <div class="mb-2">
                        <label class="detail-label mb-1">Status</label>
                        <select name="status" id="editCategoryStatus" class="form-control">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-success px-4">Update</button>
                    <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="modal fade" id="deleteCategoryModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="deleteCategoryForm">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <div class="modal-content">
                <div class="modal-header bg-danger">
                    <h5>Confirm Delete</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete
                    <strong id="deleteCategoryName"></strong>?
                </div>
                <div class="modal-footer">
                    <button class="btn btn-danger px-4">Delete</button>
                    <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
$(function () {

    $('#category-table').DataTable({
        pageLength: 10,
        columnDefs: [{ orderable: false, targets: [3,4] }]
    });

    $('#editCategoryModal').on('show.bs.modal', function (e) {
        let btn = $(e.relatedTarget);

        let id = btn.data('id');
        let name = btn.data('name');
        let status = btn.data('status');

        $('#editCategoryName').val(name);
        $('#editCategoryStatus').val(status);

        $('#editCategoryForm').attr(
            'action',
            "<?php echo e(route('admin.categories.update', ':id')); ?>".replace(':id', id)
        );
    });


    $('#deleteCategoryModal').on('show.bs.modal', function (e) {
        let btn = $(e.relatedTarget);
        let id = btn.data('id');
        let name = btn.data('name');

        $('#deleteCategoryName').text(name);
        $('#deleteCategoryForm').attr('action',
            "<?php echo e(route('admin.categories.destroy', ':id')); ?>".replace(':id', id)
        );
    });

});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Freshora\Laravel\buildours\resources\views/admin/products/categories.blade.php ENDPATH**/ ?>