

<?php $__env->startSection('title', 'Delivery Price Management'); ?>

<?php $__env->startSection('styles'); ?>
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet">

<style>
/* ===============================
   DATATABLE HEADER
=============================== */
.dataTables_wrapper table.dataTable thead th {
    background: linear-gradient(to bottom, #29B2F6, #5AF399) !important;
    color: #fff !important;
    font-size: 13px;
    font-weight: 600;
    text-transform: uppercase;
    text-align: center;
    border: none !important;
}

.dataTables_wrapper table.dataTable thead th:first-child {
    border-top-left-radius: 12px;
}
.dataTables_wrapper table.dataTable thead th:last-child {
    border-top-right-radius: 12px;
}

.dataTables_wrapper table.dataTable {
    margin-top: 12px !important;
}

.dataTables_wrapper .dataTables_filter {
    margin-bottom: 16px;
}

/* ===============================
   TABLE BODY
=============================== */
table.dataTable tbody td {
    text-align: center;
    font-size: 14px;
    border-top: 1px solid #eef2f6;
}

table.dataTable tbody tr:nth-child(odd) {
    background: #f8fbff;
}
table.dataTable tbody tr:nth-child(even) {
    background: #fff;
}

table.dataTable tbody tr {
    transition: all .25s ease;
}
table.dataTable tbody tr:hover {
    background: #e9f6ff !important;
    box-shadow: 0 6px 18px rgba(41,178,246,.15);
}

/* Active page button */
.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    border: none !important;
    border-radius: 8px !important;
    box-shadow: 0 4px 10px rgba(41,178,246,.35);
}
/* ===============================
   ICON ACTION BUTTONS (FIXED)
=============================== */
.icon-btn {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    border: none;
    background: #f1f5f9;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all .2s ease;
}

.icon-btn i {
    font-size: 15px;
}

/* EDIT */
.approve-btn {
    color: #0d6efd !important;
}
.approve-btn:hover {
    background: rgba(13,110,253,.15);
    transform: translateY(-2px);
}

/* DELETE */
.reject-btn {
    color: #ef4444 !important;
}
.reject-btn:hover {
    background: rgba(239,68,68,.15);
    transform: translateY(-2px);
}


/* ===============================
   ADD BUTTON
=============================== */
.btn-add {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-radius: 20px;
    padding: 8px 20px;
    font-weight: 600;
    border: none;
}

/* ===============================
   MODAL FIX (CENTERED & CLEAN)
=============================== */
.modal {
    overflow-y: auto;
    padding-right: 0 !important;
}

.modal-dialog {
    margin: auto !important;
    max-width: 500px;
    justify-content: center !important;
}

.modal-content {
    border-radius: 14px;
    border: none;
    box-shadow: 0 15px 40px rgba(0,0,0,.15);
}

.modal-header {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-top-left-radius: 14px;
    border-top-right-radius: 14px;
}

.modal-footer .btn {
    border-radius: 20px;
}

/* ===============================
   INPUTS
=============================== */
.form-control {
    border-radius: 10px;
}

/* ===============================
   MOBILE FIX
=============================== */
@media (max-width: 768px) {
    .table-responsive {
        overflow-x: auto;
    }
    table.dataTable {
        min-width: 700px;
    }
}

.status {
    padding: 6px 16px;
    font-size: 12px;
    font-weight: 600;
    border-radius: 30px;
    display: inline-block;
}

.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-inactive { background: #fdecea; color: #c62828; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">Delivery Price Management</h3>
        <button class="btn-add"
                data-bs-toggle="modal"
                data-bs-target="#addDeliveryPriceModal">
            <i class="fa fa-plus me-2"></i> Add Delivery Price
        </button>
    </div>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>


    
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table id="delivery-price-table" class="display w-100">
                    <thead>
                        <tr>
                            <th>S.no</th>
                            <th>Store Price</th>
                            <th>Customer Price</th>
                            <th>Default</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $prices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td>₹ <?php echo e(number_format($price->store_delivery_price, 2)); ?></td>
                            <td>₹ <?php echo e(number_format($price->customer_delivery_price, 2)); ?></td>
                            <td>
                                <?php if($price->is_default): ?>
                                    <span class="badge bg-success">Default</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">No</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($price->created_at->format('d M Y')); ?></td>
                            <td>
                                <button class="icon-btn approve-btn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#editDeliveryPriceModal"
                                        data-id="<?php echo e($price->id); ?>"
                                        data-store="<?php echo e($price->store_delivery_price); ?>"
                                        data-customer="<?php echo e($price->customer_delivery_price); ?>"
                                        data-default="<?php echo e($price->is_default); ?>">
                                    <i class="fa fa-pen"></i>
                                </button>

                                <button class="icon-btn reject-btn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#deleteDeliveryPriceModal"
                                        data-id="<?php echo e($price->id); ?>">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="addDeliveryPriceModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="<?php echo e(route('admin.delivery.store')); ?>">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Add Delivery Price</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <div class="mb-3">
                        <label class="detail-label mb-1">Store Delivery Price</label>
                        <input type="number" step="0.01" name="store_delivery_price"
                               class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="detail-label mb-1">Customer Delivery Price</label>
                        <input type="number" step="0.01" name="customer_delivery_price"
                               class="form-control" required>
                    </div>

                    <div class="form-check">
                        <input type="checkbox" name="is_default" value="1"
                               class="form-check-input" id="addDefault">
                        <label class="form-check-label" for="addDefault">
                            Set as Default
                        </label>
                    </div>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-success px-4">Save</button>
                    <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="modal fade" id="editDeliveryPriceModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="editDeliveryPriceForm">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Edit Delivery Price</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <div class="mb-3">
                        <label class="detail-label mb-1">Store Delivery Price</label>
                        <input type="number" step="0.01"
                               name="store_delivery_price"
                               id="editStorePrice"
                               class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="detail-label mb-1">Customer Delivery Price</label>
                        <input type="number" step="0.01"
                               name="customer_delivery_price"
                               id="editCustomerPrice"
                               class="form-control" required>
                    </div>

                    <div class="form-check">
                        <input type="checkbox" name="is_default" value="1"
                               class="form-check-input"
                               id="editDefault">
                        <label class="form-check-label" for="editDefault">
                            Set as Default
                        </label>
                    </div>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-success px-4">Update</button>
                    <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="modal fade" id="deleteDeliveryPriceModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="deleteDeliveryPriceForm">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <div class="modal-content">
                <div class="modal-header bg-danger">
                    <h5>Confirm Delete</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    Are you sure you want to delete this delivery price?
                </div>

                <div class="modal-footer">
                    <button class="btn btn-danger px-4">Delete</button>
                    <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
$(function () {

    $('#delivery-price-table').DataTable({
        pageLength: 10,
        columnDefs: [{ orderable: false, targets: [3,5] }]
    });

    // Edit modal
    $('#editDeliveryPriceModal').on('show.bs.modal', function (e) {
        let btn = $(e.relatedTarget);

        let id = btn.data('id');
        let store = btn.data('store');
        let customer = btn.data('customer');
        let isDefault = btn.data('default');

        $('#editStorePrice').val(store);
        $('#editCustomerPrice').val(customer);
        $('#editDefault').prop('checked', isDefault == 1);

        $('#editDeliveryPriceForm').attr(
            'action',
            "<?php echo e(route('admin.delivery.update', ':id')); ?>".replace(':id', id)
        );
    });

    // Delete modal
    $('#deleteDeliveryPriceModal').on('show.bs.modal', function (e) {
        let btn = $(e.relatedTarget);
        let id = btn.data('id');

        $('#deleteDeliveryPriceForm').attr(
            'action',
            "<?php echo e(route('admin.delivery.destroy', ':id')); ?>".replace(':id', id)
        );
    });

});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Freshora\Laravel\buildours\resources\views/admin/delivery-prices/index.blade.php ENDPATH**/ ?>