<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Admin Dashboard'); ?></title><!-- Bootstrap CSS -->

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">   
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('assets/images/logo.jpg')); ?>">

    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(to right, #29B2F6, #5AF399);
            color: #10171d;
        }

        .sidebar {
            height: 100vh;
            width: 270px;
            background: linear-gradient(to bottom, #29B2F6, #5AF399);
            color: #fff;
            display: flex;
            flex-direction: column;
            padding: 1rem 0;
            flex-shrink: 0;
            transition: left 0.3s ease-in-out;
            box-shadow: 2px 0 8px rgba(0,0,0,0.1); /* subtle shadow */
        }

        .sidebar .logo {
            text-align: center;
            margin-bottom: 1rem;
        }

        .sidebar .logo img {
            max-width: 80px;
        }

        .sidebar .nav-link {
            color: #fff;
            padding: 0.7rem 1rem;
            border-radius: 0.375rem;
            margin: 0.2rem 0.8rem;
            transition: all 0.3s ease;
        }

        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            background-color: rgba(255,255,255,0.15);
            color: #fff;
            border-left: 4px solid #fff;
        }

        .sidebar .nav-item .collapse .nav-link {
            padding-left: 2rem;
        }

        .sidebar .logout {
            margin-top: auto;
            padding: 1rem;
        }

        .sidebar .logout button {
            width: 100%;
            border: none;
            background: #fff;
            color: #29B2F6;
            padding: 0.6rem;
            border-radius: 0.375rem;
            font-weight: bold;
        }

        .sidebar .logout button:hover {
            background: #f0f0f0;
        }

        /* Main content */
        main.flex-grow-1 {
            min-width: 0;
            background-color: #f8f9fa; /* light background */
            min-height: 100vh;
        }

        .breadcrumb {
            background: #29B2F6;
            color: #fff;
        }

        .breadcrumb .breadcrumb-item a {
            color: #d1e7ff;
        }

        .breadcrumb .breadcrumb-item.active {
            color: #fff;
        }

        /* Mobile header */
        .mobile-header { display: none; }
        @media (max-width: 992px) {
            .mobile-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
                padding: 0.5rem 1rem;
                background: linear-gradient(to right, #29B2F6, #5AF399);
                color: #fff;
                position: sticky;
                top: 0;
                z-index: 1100;
            }

            #sidebarToggleMobile {
                border: none;
                background: rgba(255,255,255,0.2);
            }

            #sidebarToggleMobile:hover {
                background: rgba(255,255,255,0.35);
            }

            .sidebar {
                position: fixed;
                left: -260px;
                top: 0;
                z-index: 1200;
                height: 100%;
                box-shadow: 2px 0 8px rgba(0,0,0,0.2);
            }

            .sidebar.show { left: 0; }

            .overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0,0,0,0.5);
                z-index: 1150;
                display: none;
            }

            .overlay.show { display: block; }
        }

        @media(min-width: 992px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: 0;
                height: 100vh;
                width: 270px;
                overflow-y: auto;
                z-index: 1000;
            }

            main.flex-grow-1 {
                margin-left: 250px;
                padding: 1.5rem;
            }
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
    <?php echo $__env->yieldContent('styles'); ?>
</head>
<body>

    <!-- Mobile Header -->
    <div class="mobile-header d-lg-none">
        <div class="d-flex align-items-center">
            <img alt="logo" src="<?php echo e(asset('assets/images/logo.jpg')); ?>" style="height:40px; margin-right:10px;">
            <span class="fw-bold">Admin Panel</span>
        </div>
        <button class="btn btn-outline-light" id="sidebarToggleMobile">
            <i class="fa fa-bars"></i>
        </button>
    </div>

    <div class="d-flex">
        <!-- Sidebar -->
        <nav id="sidebar" class="sidebar">
            <div class="logo text-center">
                <img src="<?php echo e(asset('assets/images/logo.jpg')); ?>" alt="Logo" style="max-width:100px;">
            </div>

            <ul class="nav flex-column" id="sidebarAccordion">

                
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.dashboard')); ?>"
                    class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
                        <i class="fa fa-tachometer-alt me-2"></i> Dashboard
                    </a>
                </li>

                
                <?php
                    $userManagementOpen =
                        request()->routeIs('admin.users.warehouses') ||
                        request()->routeIs('admin.users.stores') ||
                        request()->routeIs('admin.users.show') ||
                        request()->routeIs('admin.riders*') ||
                        request()->routeIs('admin.customers*');
                ?>

                <li class="nav-item">
                    <a class="nav-link d-flex justify-content-between align-items-center
                        <?php echo e($userManagementOpen ? 'active' : ''); ?>"
                    data-bs-toggle="collapse"
                    href="#userManagement"
                    role="button"
                    aria-expanded="<?php echo e($userManagementOpen ? 'true' : 'false'); ?>">
                        <span><i class="fa fa-users me-2"></i> User Management</span>
                        <i class="fa fa-chevron-down"></i>
                    </a>

                    <div class="collapse <?php echo e($userManagementOpen ? 'show' : ''); ?>"
                        id="userManagement"
                        data-bs-parent="#sidebarAccordion">

                        <ul class="nav flex-column ms-3">

                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request()->routeIs('admin.users.warehouses') ? 'active' : ''); ?>"
                                href="<?php echo e(route('admin.users.warehouses')); ?>">
                                    Warehouses
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request()->routeIs('admin.users.stores') ? 'active' : ''); ?>"
                                href="<?php echo e(route('admin.users.stores')); ?>">
                                    Stores
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request()->routeIs('admin.customers*') ? 'active' : ''); ?>"
                                href="<?php echo e(route('admin.customers.index')); ?>">
                                    Customers
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request()->routeIs('admin.riders*') ? 'active' : ''); ?>"
                                href="<?php echo e(route('admin.riders.index')); ?>">
                                    Riders
                                </a>
                            </li>

                        </ul>
                    </div>
                </li>

                
                <?php
                    $productManagementOpen =
                        request()->routeIs('admin.products*') ||
                        request()->routeIs('admin.categories*') ||
                        request()->routeIs('admin.subcategories*') ||
                        request()->routeIs('admin.brands*') ||
                        request()->routeIs('admin.quantity-units*') ||
                        request()->routeIs('admin.product-reviews*');
                ?>

                <li class="nav-item">
                    <a class="nav-link d-flex justify-content-between align-items-center
                        <?php echo e($productManagementOpen ? 'active' : ''); ?>"
                    data-bs-toggle="collapse"
                    href="#productManagement"
                    role="button"
                    aria-expanded="<?php echo e($productManagementOpen ? 'true' : 'false'); ?>">
                        <span><i class="fa-solid fa-boxes-stacked me-2"></i> Product Management</span>
                        <i class="fa fa-chevron-down"></i>
                    </a>

                    <div class="collapse <?php echo e($productManagementOpen ? 'show' : ''); ?>"
                        id="productManagement"
                        data-bs-parent="#sidebarAccordion">

                        <ul class="nav flex-column ms-3">

                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request()->routeIs('admin.products*') ? 'active' : ''); ?>"
                                href="<?php echo e(route('admin.products')); ?>">
                                    Products
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request()->routeIs('admin.categories*') ? 'active' : ''); ?>"
                                href="<?php echo e(route('admin.categories.index')); ?>">
                                    Categories
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request()->routeIs('admin.subcategories*') ? 'active' : ''); ?>"
                                href="<?php echo e(route('admin.subcategories.index')); ?>">
                                    SubCategories
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request()->routeIs('admin.quantity-units*') ? 'active' : ''); ?>"
                                href="<?php echo e(route('admin.quantity-units.index')); ?>">
                                    Quantity Units
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request()->routeIs('admin.brands*') ? 'active' : ''); ?>"
                                href="<?php echo e(route('admin.brands.index')); ?>">
                                    Brands
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request()->routeIs('admin.product-reviews*') ? 'active' : ''); ?>"
                                href="<?php echo e(route('admin.product-reviews.index')); ?>">
                                    Product Reviews
                                </a>
                            </li>

                        </ul>
                    </div>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(route('admin.delivery.index')); ?>"
                    class="nav-link <?php echo e(request()->routeIs('admin.delivery*') ? 'active' : ''); ?>">
                        <i class="fa fa-truck me-2"></i> Delivery Management
                    </a>
                </li>


                
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.orders.index')); ?>"
                    class="nav-link <?php echo e(request()->routeIs('admin.orders*') ? 'active' : ''); ?>">
                        <i class="fa fa-shopping-cart me-2"></i> Orders
                    </a>
                </li>


            </ul>

            
            <div class="logout mt-auto p-3">
                <button type="button" class="btn w-100" data-bs-toggle="modal" data-bs-target="#logoutModal">
                    <i class="fa fa-sign-out-alt me-1"></i> Logout
                </button>

                <form id="logout-form" action="<?php echo e(route('admin.logout')); ?>" method="POST" class="d-none">
                    <?php echo csrf_field(); ?>
                </form>
            </div>
        </nav>


        <!-- Overlay for mobile -->
        <div id="overlay" class="overlay"></div>

        <!-- Main Content -->
        <main class="flex-grow-1">
            <?php if (! empty(trim($__env->yieldContent('header_actions')))): ?>
                <?php echo $__env->yieldContent('header_actions'); ?>
            <?php endif; ?>

            <?php if(View::hasSection('breadcrumb')): ?>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb px-3 py-2 rounded shadow-sm mb-4">
                        <?php echo $__env->yieldContent('breadcrumb'); ?>
                    </ol>
                </nav>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>

    <div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="logoutModalLabel">Confirm Logout</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to logout?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmLogout">Logout</button>
                </div>
            </div>
        </div>
    </div>

    <!-- 1️⃣ jQuery FIRST -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>

    <!-- 2️⃣ Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- 3️⃣ DataTables Core -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

    <!-- 4️⃣ DataTables Responsive -->
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script> 
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>

    <!-- 5️⃣ Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(function () {
            $('#sidebarToggleMobile').on('click', function () {
                $('#sidebar').toggleClass('show');
                $('#overlay').toggleClass('show');
            });
            $('#overlay').on('click', function () {
                $('#sidebar').removeClass('show');
                $(this).removeClass('show');
            });
        });

        document.querySelectorAll('#sidebarAccordion .collapse').forEach(function (el) {
            el.addEventListener('show.bs.collapse', function () {
                document.querySelectorAll('#sidebarAccordion .collapse.show').forEach(function (openEl) {
                    if (openEl !== el) {
                        bootstrap.Collapse.getInstance(openEl)?.hide();
                    }
                });
            });
        });

        document.getElementById('confirmLogout').addEventListener('click', function() {
            document.getElementById('logout-form').submit();
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH /home2/buildours/live-app.buildours.in/resources/views/admin/layouts/app.blade.php ENDPATH**/ ?>