

<?php $__env->startSection('title', ucfirst($type).' Details'); ?>

<?php $__env->startSection('styles'); ?>
<style>
/* ===============================
   DETAIL PAGE STYLING
=============================== */
.card {
    border: none;
    border-radius: 12px;
    box-shadow: 0 8px 20px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
}
.card-header {
    background: linear-gradient(to bottom, #29B2F6, #5AF399);
    color: #fff;
    font-weight: 600;
    font-size: 1.1rem;
    border-top-left-radius: 12px;
    border-top-right-radius: 12px;
}
.detail-row {
    margin-bottom: 1rem;
}
.detail-label {
    font-weight: 600;
    color: #374151;
}
.detail-value {
    color: #111827;
}
.status-badge {
    padding: 6px 16px;
    border-radius: 30px;
    font-weight: 600;
    font-size: 0.9rem;
}
.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-pending { background: #fff5e5; color: #d48806; }
.status-rejected { background: #fdecea; color: #c62828; }

.btn-back {
    background: #f0f4f8;
    color: #10171d;
    font-weight: 500;
    border-radius: 8px;
}
.action-btn {
    padding: 10px 24px;
    border-radius: 8px;
    font-weight: 600;
    margin-right: 12px;
    border: none;
}
.action-approve { background: #22c55e; color: #fff; }
.action-reject { background: #ef4444; color: #fff; }
.modal-header {
    background: linear-gradient(to bottom, #29B2F6, #5AF399);
    color: #fff;
}

.modal-dialog {
    margin-left: auto !important;
    margin-right: auto !important;
    justify-content: center !important;
}

.modal {
    padding-right: 0 !important;
}

th{
    text-align: center;
}


</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold"><?php echo e(ucfirst($type)); ?> Details</h3>
        <a href="<?php echo e(route('admin.users.'.$type.'s')); ?>" class="btn btn-back btn-sm">
            ← Back to <?php echo e(ucfirst($type)); ?>s
        </a>
    </div>

    <!-- Validation Errors -->
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <!-- Approve / Reject -->
    <?php if($item->status == 'pending_admin'): ?>
    <div class="mb-4">
        <button class="action-btn action-approve" data-bs-toggle="modal" data-bs-target="#approveModal">Approve</button>
        <button class="action-btn action-reject" data-bs-toggle="modal" data-bs-target="#rejectModal">Reject</button>
    </div>
    <?php endif; ?>

    <!-- General Information -->
    <div class="card">
        <div class="card-header">General Information</div>
        <div class="card-body">

            <div class="text-center mb-3">
                <?php if($item->logo && file_exists(public_path($item->logo))): ?>
                    <img src="<?php echo e(asset($item->logo)); ?>" alt="Logo" class="img-fluid rounded" style="max-height: 120px;">
                <?php else: ?>
                    <span class="text-muted d-block">No logo uploaded</span>
                <?php endif; ?>
            </div>


            <div class="row detail-row">
                <div class="col-md-6">
                    <span class="detail-label">Owner Name:</span>
                    <span class="detail-value"><?php echo e($item->owner_name); ?></span>
                </div>
                <div class="col-md-6">
                    <span class="detail-label"><?php echo e(ucfirst($type)); ?> Name:</span>
                    <span class="detail-value">
                        <?php echo e($type === 'warehouse' ? $item->warehouse_name : $item->store_name); ?>

                    </span>
                </div>
            </div>

            <div class="row detail-row">
                <div class="col-md-6"><span class="detail-label">Email:</span> <?php echo e($item->email); ?></div>
                <div class="col-md-6"><span class="detail-label">Mobile:</span> <?php echo e($item->mobile_number); ?></div>
            </div>

            <div class="row detail-row">
                <div class="col-md-6">
                    <span class="detail-label">Status:</span>
                    <span class="status-badge
                        <?php echo e($item->status == 'active' ? 'status-active' : ($item->status == 'pending_admin' ? 'status-pending' : 'status-rejected')); ?>">
                        <?php echo e(ucfirst($item->status)); ?>

                    </span>
                </div>
                <div class="col-md-6"><span class="detail-label">Business Type:</span> <?php echo e($item->business_type ?? 'N/A'); ?></div>
            </div>
        </div>
    </div>


   <!-- Products Table -->
    <div class="card">
        <div class="card-header">Products</div>
        <div class="card-body table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Category</th>
                        <th>Subcategory</th>
                        <th>Unit</th>
                        <th>Brand</th>
                        <th>Price</th>
                        <th>Remark</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $item->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($i + 1); ?></td>
                        <td><?php echo e($product->category->name ?? 'N/A'); ?></td>
                        <td><?php echo e($product->subcategory->name ?? 'N/A'); ?></td>
                        <td><?php echo e($product->quantityUnit->name ?? 'N/A'); ?></td>
                        <td><?php echo e($product->brand->name ?? 'N/A'); ?></td>
                        <td style="text-align: right;"><?php echo e(number_format($product->price, 2)); ?></td>
                        <td style="text-align: center;"><?php echo e($product->admin_remark ?? 'N/A'); ?></td>
                        <td style="text-align: center;">
                            <?php if($product->status == 'pending'): ?>
                                <button
                                    class="btn btn-success btn-sm product-approve-btn"
                                    data-bs-toggle="modal"
                                    data-bs-target="#productApproveModal"
                                    data-id="<?php echo e($product->id); ?>"
                                    data-type="<?php echo e($type); ?>"
                                    data-name="<?php echo e($product->material_name); ?>"
                                    data-has-product="<?php echo e($product->product_id ? '1' : '0'); ?>">
                                    Approve
                                </button>


                                <button
                                    class="btn btn-danger btn-sm product-reject-btn"
                                    data-bs-toggle="modal"
                                    data-bs-target="#productRejectModal"
                                    data-id="<?php echo e($product->id); ?>"
                                    data-type="<?php echo e($type); ?>"
                                    data-name="<?php echo e($product->material_name); ?>">
                                    Reject
                                </button>
                            <?php else: ?>
                                <span class="text-muted">Done</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Address -->
    <div class="card">
        <div class="card-header">Address</div>
        <div class="card-body">
            <?php echo e($item->door_no); ?>, <?php echo e($item->street_name); ?>, <?php echo e($item->area); ?>,
            <?php echo e($item->city); ?>, <?php echo e($item->district->name ?? 'N/A'); ?>,
            <?php echo e($item->state->name ?? 'N/A'); ?> - <?php echo e($item->pincode); ?>,
            <?php echo e($item->country); ?>

        </div>
    </div>

    <!-- Legal -->
    <div class="card">
        <div class="card-header">Legal Information</div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <p><strong>Business Status:</strong> <?php echo e(ucfirst($item->business_status)); ?></p>
                    <p><strong>GST:</strong> <?php echo e($item->gst_number ?? 'N/A'); ?></p>
                    <p><strong>PAN:</strong> <?php echo e($item->pan_number); ?></p>
                </div>

                <div class="col-md-6">
                    <p><strong>AAdhar No:</strong> <?php echo e($item->aadhar_number); ?></p>
                    <p><strong>Trade License:</strong> <?php echo e($item->trade_license_number ?? 'N/A'); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Bank -->
    <div class="card">
        <div class="card-header">Bank Information</div>
        <div class="card-body">

            <div class="row">
                <!-- Approved Bank Details -->
                <div class="col-md-6">
                    <h6>Approved Bank Details</h6>
                    <p><strong>Account Holder:</strong> <?php echo e($item->bank_holder_name); ?></p>
                    <p><strong>Bank:</strong> <?php echo e($item->bank->name ?? 'N/A'); ?></p>
                    <p><strong>Account:</strong> <?php echo e($item->bank_account_number); ?></p>
                    <p><strong>IFSC:</strong> <?php echo e($item->ifsc_code); ?></p>
                    <p><strong>MICR:</strong> <?php echo e($item->micr_no ?? 'N/A'); ?></p>
                    <p><strong>UPI:</strong> <?php echo e($item->upi_id ?? 'N/A'); ?></p>
                    <p>
                        <strong>Passbook:</strong>
                        <?php if($item->passbook_file && file_exists(public_path($item->passbook_file))): ?>
                            <a href="<?php echo e(asset($item->passbook_file)); ?>" target="_blank">View</a>
                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </p>
                </div>

                <!-- Pending Bank Update -->
                <?php
                    $pending = is_array($item->pending_bank_data) ? $item->pending_bank_data : json_decode($item->pending_bank_data, true);
                ?>

                <?php if(!empty($pending)): ?>
                <div class="col-md-6">
                    <h6>Pending Update</h6>
                    <p><strong>Account Holder:</strong> <?php echo e($pending['bank_holder_name']); ?></p>
                    <p><strong>Bank:</strong> <?php echo e(\App\Models\Bank::find($pending['bank_id'])->name ?? 'N/A'); ?></p>
                    <p><strong>Account:</strong> <?php echo e($pending['bank_account_number']); ?></p>
                    <p><strong>IFSC:</strong> <?php echo e($pending['ifsc_code']); ?></p>
                    <p><strong>MICR:</strong> <?php echo e($pending['micr_no'] ?? 'N/A'); ?></p>
                    <p><strong>UPI:</strong> <?php echo e($pending['upi_id'] ?? 'N/A'); ?></p>
                    <p>
                        <strong>Passbook:</strong>
                        <?php if(!empty($pending['passbook_file']) && file_exists(public_path($pending['passbook_file']))): ?>
                            <a href="<?php echo e(asset($pending['passbook_file'])); ?>" target="_blank">View</a>
                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </p>

                    <div class="mt-3">
                        <button
                            class="btn btn-success btn-sm bank-approve-btn"
                            data-bs-toggle="modal"
                            data-bs-target="#bankApproveModal"
                            data-id="<?php echo e($item->id); ?>"
                            data-type="<?php echo e($type); ?>">
                            Approve Bank
                        </button>

                        <button
                            class="btn btn-danger btn-sm bank-reject-btn"
                            data-bs-toggle="modal"
                            data-bs-target="#bankRejectModal"
                            data-id="<?php echo e($item->id); ?>"
                            data-type="<?php echo e($type); ?>">
                            Reject Bank
                        </button>
                    </div>

                    <?php if($item->admin_remark): ?>
                    <span class="text-muted mt-2 d-block">
                        Admin Remark: <?php echo e($item->admin_remark); ?>

                    </span>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>

        </div>
    </div>


</div>

<div class="modal fade" id="approveModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="<?php echo e(route('admin.users.approve', ['type' => $type, 'id' => $item->id])); ?>">
            <?php echo csrf_field(); ?>
            <div class="modal-content rounded-4 shadow-sm">
                
                <div class="modal-header bg-success text-white justify-content-center">
                    <h5 class="modal-title text-center">
                        <i class="fas fa-check-circle me-2"></i>
                        Approve <?php echo e(ucfirst($type)); ?>

                    </h5>
                </div>

                <div class="modal-body text-center py-4">
                    <p class="mb-0 fs-6">
                        Are you sure you want to approve this <?php echo e($type); ?>?
                    </p>
                </div>

                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary px-4" data-bs-dismiss="modal">
                        Cancel
                    </button>
                    <button type="submit" class="btn btn-success px-4">
                        Approve
                    </button>
                </div>

            </div>
        </form>
    </div>
</div>


<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="<?php echo e(route('admin.users.reject', ['type' => $type, 'id' => $item->id])); ?>">
            <?php echo csrf_field(); ?>
            <div class="modal-content rounded-4 shadow-sm">
                
                <div class="modal-header bg-danger text-white justify-content-center">
                    <h5 class="modal-title text-center">
                        <i class="fas fa-times-circle me-2"></i>
                        Reject <?php echo e(ucfirst($type)); ?>

                    </h5>
                </div>

                <div class="modal-body">
                    <textarea
                        name="admin_remark"
                        class="form-control"
                        rows="4"
                        required
                        placeholder="Enter reason for rejection">
                    </textarea>
                </div>

                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary px-4" data-bs-dismiss="modal">
                        Cancel
                    </button>
                    <button type="submit" class="btn btn-danger px-4">
                        Reject
                    </button>
                </div>

            </div>
        </form>
    </div>
</div>


<div class="modal fade" id="bankApproveModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="">
            <?php echo csrf_field(); ?>
            <div class="modal-content rounded-4 shadow-sm">
                <div class="modal-header bg-success text-white justify-content-center">
                    <h5 class="modal-title text-center">
                        Approve Bank Details
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center py-4">
                    Are you sure you want to approve the bank details request?
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary px-4" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success px-4">Approve</button>
                </div>
            </div>
        </form>
    </div>
</div>



<div class="modal fade" id="bankRejectModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="">
            <?php echo csrf_field(); ?>
            <div class="modal-content rounded-4 shadow-sm">
                <div class="modal-header bg-danger text-white justify-content-center">
                    <h5 class="modal-title text-center">Reject Bank Details</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center py-4">
                    Are you sure you want to reject the bank details request?
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary px-4" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger px-4">Reject</button>
                </div>
            </div>
        </form>
    </div>
</div>






<div class="modal fade" id="productApproveModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <form method="POST" action="" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="modal-content rounded-4 shadow-sm">
                <div class="modal-header bg-success text-white justify-content-center">
                    <h5 class="modal-title">Approve Product</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <p class="text-center mb-3">
                        Approve <strong id="approveProductName"></strong>
                    </p>

                    
                    <div id="productExtraFields" class="d-none">

                        <div class="mb-3">
                            <label class="form-label">Product Image</label>
                            <input type="file" name="image" class="form-control">
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Store Price</label>
                                <input type="number" step="0.01" name="store_price" class="form-control">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">Customer Price</label>
                                <input type="number" step="0.01" name="customer_price" class="form-control">
                            </div>
                        </div>

                    </div>
                </div>

                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Approve</button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="modal fade" id="productRejectModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="">
            <?php echo csrf_field(); ?>
            <div class="modal-content rounded-4 shadow-sm">
                <div class="modal-header bg-danger text-white justify-content-center">
                    <h5 class="modal-title text-center">
                        Reject Product
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <textarea
                        name="admin_remark"
                        class="form-control"
                        rows="3"
                        placeholder="Reason for rejection (optional)"></textarea>
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary px-4" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger px-4">Reject</button>
                </div>
            </div>
        </form>
    </div>
</div>


<script>
document.addEventListener('DOMContentLoaded', function () {

    const approveModal = document.getElementById('productApproveModal');

        approveModal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;

            const productId = button.getAttribute('data-id');
            const productType = button.getAttribute('data-type');
            const productName = button.getAttribute('data-name');
            const hasProduct = button.getAttribute('data-has-product');

            const form = approveModal.querySelector('form');
            const nameElem = approveModal.querySelector('#approveProductName');
            const extraFields = approveModal.querySelector('#productExtraFields');

            form.action = `/admin/${productType}/products/${productId}/approve`;
            nameElem.textContent = productName;

            // Show extra fields if product does not exist
            if (hasProduct === '0') {
                extraFields.classList.remove('d-none');
            } else {
                extraFields.classList.add('d-none');
            }
        });

    const rejectModal = document.getElementById('productRejectModal');
    rejectModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;

        const productId = button.getAttribute('data-id');
        const productType = button.getAttribute('data-type');

        const form = rejectModal.querySelector('form');
        form.action = `/admin/${productType}/products/${productId}/reject`;
    });

});

document.addEventListener('DOMContentLoaded', function () {

    const bankApproveModal = document.getElementById('bankApproveModal');
    bankApproveModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const id = button.getAttribute('data-id');
        const type = button.getAttribute('data-type');

        const form = bankApproveModal.querySelector('form');
        form.action = `/admin/users/${type}/${id}/bank/approve`;
    });

    const bankRejectModal = document.getElementById('bankRejectModal');
    bankRejectModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const id = button.getAttribute('data-id');
        const type = button.getAttribute('data-type');

        const form = bankRejectModal.querySelector('form');
        form.action = `/admin/users/${type}/${id}/bank/reject`;
    });

});


</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Freshora\Laravel\buildours\resources\views/admin/users/show.blade.php ENDPATH**/ ?>