 

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('styles'); ?>
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet">

<style>
/* ===== Dashboard Container ===== */
.dashboard-wrap {
    background: #f6f9fc;
    min-height: 100vh;
    padding: 1.5rem;
}

/* ===== Hero Header ===== */
.dashboard-hero {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    border-radius: 18px;
    padding: 1.8rem 2rem;
    color: #fff;
    box-shadow: 0 10px 30px rgba(41,178,246,0.25);
}

.dashboard-hero h2 {
    font-size: 1.6rem;
}

.dashboard-hero .btn {
    border-radius: 10px;
    font-weight: 600;
}

/* ===== Section Headings ===== */
.section-heading {
    font-size: 0.9rem;
    font-weight: 600;
    color: #6b7280;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    margin-bottom: 0.75rem;
}
/* ================= KPI CARDS ================= */

.kpi-card {
    background: #ffffff;
    border-radius: 18px;
    padding: 1.4rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
    height: 100%;
    position: relative;
    overflow: hidden;
    cursor: pointer;

    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.06);
    transition: transform 0.25s ease, box-shadow 0.25s ease;
}

/* Card hover = clearly interactive */
.kpi-card:hover {
    transform: translateY(-6px);
    box-shadow: 0 16px 40px rgba(0, 0, 0, 0.18);
}

/* Title */
.kpi-card small {
    font-size: 0.75rem;
    font-weight: 700;
    letter-spacing: 0.03em;
    text-transform: uppercase;
    color: #6b7280;
    position: relative;
    z-index: 2;
}

/* Icon */
.kpi-card i {
    font-size: 2.8rem;
    opacity: 0.18;
    position: relative;
    z-index: 2;
    transition: transform 0.25s ease;
}

.kpi-card:hover i {
    transform: scale(1.1);
}

/* ================= GRADIENT OVERLAY ================= */

.kpi-card::before {
    content: "";
    position: absolute;
    inset: 0;
    opacity: 0.08;
    z-index: 1;
}

/* Sidebar-matched gradients */
.gradient-blue::before {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
}

.gradient-purple::before {
    background: linear-gradient(135deg, #8b5cf6, #ec4899);
}

.gradient-green::before {
    background: linear-gradient(135deg, #22c55e, #5AF399);
}

.gradient-orange::before {
    background: linear-gradient(135deg, #fb923c, #fde047);
}

.gradient-teal::before {
    background: linear-gradient(135deg, #14b8a6, #5eead4);
}

.gradient-indigo::before {
    background: linear-gradient(135deg, #6366f1, #818cf8);
}

.gradient-success::before {
    background: linear-gradient(135deg, #22c55e, #86efac);
}

.gradient-red::before {
    background: linear-gradient(135deg, #ef4444, #f87171);
}

/* ================= KPI STATS ================= */

.kpi-stats {
    display: flex;
    gap: 16px;
    margin-top: 10px;
    position: relative;
    z-index: 2;
}

/* Clickable stat links */
.kpi-value,
.kpi-sub {
    text-decoration: none;
    display: flex;
    flex-direction: column;
    padding-right: 16px;
    position: relative;
    transition: all 0.2s ease;
}

/* Numbers */
.kpi-value {
    font-size: 26px;
    font-weight: 800;
    color: #111827;
}

.kpi-sub {
    font-size: 18px;
    font-weight: 700;
    color: #f59e0b;
}

/* Labels */
.kpi-value span,
.kpi-sub span {
    font-size: 11px;
    font-weight: 600;
    opacity: 0.85;
}

/* Arrow indicator (UX hint) */
.kpi-value::after,
.kpi-sub::after {
    content: "→";
    position: absolute;
    right: 0;
    top: 4px;
    opacity: 0;
    transform: translateX(-4px);
    transition: all 0.25s ease;
}

/* Hover = obvious click */
.kpi-value:hover::after,
.kpi-sub:hover::after {
    opacity: 1;
    transform: translateX(3px);
}

.kpi-value:hover,
.kpi-sub:hover {
    text-decoration: underline;
}

.kpi-sub {
    color: #ef4444;
}



/* ===== Tables ===== */
.dashboard-table {
    background: #fff;
    border-radius: 18px;
    border: none;
    box-shadow: 0 4px 15px rgba(0,0,0,0.05);
}

.dashboard-table thead th {
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    color: #6b7280;
    border-bottom: 1px solid #e5e7eb;
    background: #fff;
    position: sticky;
    top: 0;
    z-index: 10;
    box-shadow: inset 0 -1px 0 #e5e7eb;
}

.dashboard-table tbody tr { transition: background 0.2s ease; }
.dashboard-table tbody tr:hover { background: #f9fafb; }

/* ===== Status / Badges ===== */
.status-pending {
    background: #fff7ed;
    color: #f97316;
    padding: 4px 10px;
    border-radius: 999px;
    font-size: 0.75rem;
    font-weight: 600;
}

.count-pill {
    background: rgba(41,178,246,0.1);
    color: #29B2F6;
    padding: 4px 12px;
    border-radius: 999px;
    font-weight: 700;
}

.badge-type {
    padding: 5px 12px;
    border-radius: 999px;
    font-size: 0.7rem;
    font-weight: 600;
    text-transform: uppercase;
}

/* ===== Action Buttons ===== */
.icon-btn {
    background: #f3f4f6;
    border: none;
    border-radius: 10px;
    padding: 6px 9px;
    margin-right: 4px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.icon-btn:hover { background: #e5e7eb; }
.view-btn { color: #2563eb; }
.approve-btn { color: #16a34a; }
.reject-btn { color: #dc2626; }

/* ===== Scrollable Table Body ===== */
.table-scroll {
    max-height: 260px;
    overflow-y: auto;
    overflow-x: hidden;
    display: block;
}

.table-scroll::-webkit-scrollbar {
    width: 6px;
}
.table-scroll::-webkit-scrollbar-track { background: transparent; }
.table-scroll::-webkit-scrollbar-thumb {
    background: rgba(0,0,0,0.2);
    border-radius: 10px;
}

.table-scroll tr {
    display: table;
    width: 100%;
    table-layout: fixed;
}

.table-scroll td, 
.table-scroll th {
    padding: 0.75rem;
}

table thead, table tbody tr {
    display: table;
    width: 100%;
    table-layout: fixed;
}

table thead {
    width: calc(100% - 1em); /* adjust for scrollbar */
}


/* Style like Product Pending Status */
.status {
    padding: 4px 10px;
    border-radius: 999px;
    font-size: 0.75rem;
    font-weight: 600;
    display: inline-block;
}

/* Different colors per type */
.status-warehouse {
    background: #eff6ff;  /* light blue */
    color: #2563eb;       /* blue */
}

.status-rider {
    background: #f0fdf4;  /* light green */
    color: #16a34a;       /* green */
}

.status-store {
    background: #fffbeb;  /* light yellow */
    color: #b45309;       /* amber/orange */
}
/* ===== Orders Workflow Cards ===== */
.order-status-card {
    background: #fff;
    border-radius: 14px;
    padding: 14px 16px;
    display: block;
    text-decoration: none;
    color: #111827;
    border-left: 5px solid transparent;
    box-shadow: 0 6px 18px rgba(0,0,0,0.06);
    transition: all 0.25s ease;
}

.order-status-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 12px 28px rgba(0,0,0,0.12);
    background: #f9fafb;
}

/* Border variants */
.border-info    { border-left-color: #0dcaf0; }
.border-primary { border-left-color: #0d6efd; }
.border-warning { border-left-color: #f59e0b; }
.border-success { border-left-color: #22c55e; }
.border-danger  { border-left-color: #ef4444; }
.border-indigo  { border-left-color: #6366f1; }
.border-teal    { border-left-color: #14b8a6; }

/* Content */
.order-count {
    font-size: 26px;
    font-weight: 700;
}

.order-label {
    font-size: 12px;
    color: #6b7280;
    margin-top: -2px;
}

.order-icon {
    font-size: 1.4rem;
    opacity: 0.35;
}


</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid dashboard-wrap">

    
    <div class="dashboard-hero mb-4">
        <div class="row align-items-center">
            <div class="col-md-7">
                <h2 class="fw-bold mb-1">
                    Welcome back, <?php echo e(auth()->user()->name); ?>

                </h2>
                <p class="text-light opacity-75 mb-0">
                    Buildours Admin Panel · <?php echo e(now()->format('l, F j, Y')); ?>

                </p>
            </div>
            <div class="col-md-5 text-md-end mt-3 mt-md-0">
                <a href="<?php echo e(route('admin.products')); ?>" class="btn btn-outline-light me-2">
                    <i class="fas fa-box me-1"></i> Products
                </a>
                <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn btn-light text-dark fw-semibold">
                    <i class="fas fa-shopping-cart me-1"></i> Orders
                </a>
            </div>
        </div>
    </div>

    
    <h6 class="section-heading">System Overview</h6>
    <div class="row g-4 mb-4">

        
        <div class="col-md-3">
            <div class="kpi-card gradient-blue">
                <div>
                    <small>Warehouses</small>
                    <div class="kpi-stats">
                        <a href="<?php echo e(route('admin.users.warehouses', ['status' => 'active'])); ?>" class="kpi-value">
                            <?php echo e($warehouseStats->active ?? 0); ?><span>Approved</span>
                        </a>
                        <a href="<?php echo e(route('admin.users.warehouses', ['status' => 'pending_admin'])); ?>" class="kpi-sub">
                            <?php echo e($warehouseStats->pending ?? 0); ?><span>Pending</span>
                        </a>
                    </div>
                </div>
                <i class="fas fa-warehouse"></i>
            </div>
        </div>

        
        <div class="col-md-3">
            <div class="kpi-card gradient-purple">
                <div>
                    <small>Stores</small>
                    <div class="kpi-stats">
                        <a href="<?php echo e(route('admin.users.stores', ['status' => 'active'])); ?>" class="kpi-value">
                            <?php echo e($storeStats->active ?? 0); ?><span>Approved</span>
                        </a>
                        <a href="<?php echo e(route('admin.users.stores', ['status' => 'pending_admin'])); ?>" class="kpi-sub">
                            <?php echo e($storeStats->pending ?? 0); ?><span>Pending</span>
                        </a>
                    </div>
                </div>
                <i class="fas fa-store"></i>
            </div>
        </div>

        
        <div class="col-md-3">
            <div class="kpi-card gradient-green">
                <div>
                    <small>Riders</small>
                    <div class="kpi-stats">
                        <a href="<?php echo e(route('admin.riders.index', ['status' => 'active'])); ?>" class="kpi-value">
                            <?php echo e($riderStats->active ?? 0); ?><span>Approved</span>
                        </a>
                        <a href="<?php echo e(route('admin.riders.index', ['status' => 'pending_admin'])); ?>" class="kpi-sub">
                            <?php echo e($riderStats->pending ?? 0); ?><span>Pending</span>
                        </a>
                    </div>
                </div>
                <i class="fas fa-motorcycle"></i>
            </div>
        </div>

        
        <div class="col-md-3">
            <div class="kpi-card gradient-orange">
                <div>
                    <small>Customers</small>
                    <div class="kpi-stats">
                        <a href="<?php echo e(route('admin.customers.index', ['status' => 'active'])); ?>" class="kpi-value">
                            <?php echo e($customerStats->active ?? 0); ?><span>Active</span>
                        </a>
                        <a href="<?php echo e(route('admin.customers.index', ['status' => 'blocked'])); ?>" class="kpi-sub">
                            <?php echo e($customerStats->blocked ?? 0); ?><span>Blocked</span>
                        </a>
                    </div>
                </div>
                <i class="fas fa-user"></i>
            </div>
        </div>

    </div>

    
    <h6 class="section-heading d-flex align-items-center gap-2">
        <i class="fas fa-route text-primary"></i>
        Orders Workflow
    </h6>

    <div class="row g-3 mb-4">

    <?php
    $orderStatuses = [
        'pending_assignment' => ['Pending Assignment', 'clipboard-list', 'border-info'],
        'order_taken' => ['Order Taken', 'hand-paper', 'border-primary'],
        'waiting_for_rider_approval' => ['Waiting for Rider', 'user-clock', 'border-warning'],
        'rider_accepted' => ['Rider Accepted', 'user-check', 'border-success'],
        'rider_verified' => ['Rider Verified', 'id-card', 'border-teal'],
        'in_transit' => ['In Transit', 'truck', 'border-indigo'],
        'completed' => ['Completed', 'check-circle', 'border-success'],
        'cancelled' => ['Cancelled', 'x-circle', 'border-danger'],
    ];
    ?>

    <?php $__currentLoopData = $orderStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => [$label, $icon, $border]): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-3 col-lg-3">
            <a href="<?php echo e(route('admin.orders.index', ['status' => $key])); ?>"
            class="order-status-card <?php echo e($border); ?>">

                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <div class="order-count">
                            <?php echo e($orderStats[$key] ?? 0); ?>

                        </div>
                        <div class="order-label">
                            <?php echo e($label); ?>

                        </div>
                    </div>

                    <i class="fas fa-<?php echo e($icon); ?> order-icon"></i>
                </div>

            </a>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>

    
    <h6 class="section-heading d-flex justify-content-between align-items-center">
        Pending Product Approvals
        <span class="count-pill"><?php echo e($pendingProducts->count()); ?> Total</span>
    </h6>
    <div class="card shadow rounded-4 p-3 mb-4 dashboard-table">
        <table class="table align-middle mb-0 table-fixed">
            <thead>
                <tr>
                    <th class="text-start">Owner</th>
                    <th class="text-center">Type</th>
                    <th class="text-center">Pending</th>
                    <th class="text-center">Last Request</th>
                    <th class="text-center">Action</th>
                </tr>
            </thead>
            <tbody class="table-scroll">
                <?php $__empty_1 = true; $__currentLoopData = $pendingProducts->take(7); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="text-start"><?php echo e($row->owner_name); ?></td>

                    <!-- User Type with colored status -->
                    <td class="text-center">
                        <span class="status
                            <?php if($row->type === 'warehouse'): ?> status-warehouse
                            <?php elseif($row->type === 'rider'): ?> status-rider
                            <?php elseif($row->type === 'store'): ?> status-store
                            <?php else: ?> status-pending
                            <?php endif; ?>">
                            <?php echo e(ucfirst($row->type)); ?>

                        </span>
                    </td>

                    <td class="text-center"><span class="count-pill"><?php echo e($row->pending_count); ?></span></td>
                    <td class="text-center"><?php echo e(\Carbon\Carbon::parse($row->last_requested_at)->format('d M Y')); ?></td>
                    <td class="text-center">
                        <a href="<?php echo e(route('admin.users.show', ['type'=>$row->type,'id'=>$row->owner_id])); ?>" class="icon-btn view-btn">
                            <i class="fa-solid fa-eye"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="text-muted py-4 text-center">No pending products</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    
    <h6 class="section-heading d-flex justify-content-between align-items-center">
        Pending Bank Detail Approvals
        <span class="count-pill"><?php echo e($pendingBanks->count()); ?> Total</span>
    </h6>
    <div class="card shadow rounded-4 p-3 dashboard-table">
        <table class="table align-middle mb-0 table-fixed">
            <thead>
                <tr>
                    <th class="text-start">Owner</th>
                    <th class="text-center">User Type</th>
                    <th class="text-center">Requested On</th>
                    <th class="text-center">Action</th>
                </tr>
            </thead>
            <tbody class="table-scroll">
                <?php $__empty_1 = true; $__currentLoopData = $pendingBanks->take(7); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="text-start"><?php echo e($row->owner_name); ?></td>
                    <td class="text-center">
                        <span class="status
                            <?php if($row->type === 'warehouse'): ?> status-warehouse
                            <?php elseif($row->type === 'rider'): ?> status-rider
                            <?php elseif($row->type === 'store'): ?> status-store
                            <?php endif; ?>">
                            <?php echo e(ucfirst($row->type)); ?>

                        </span>
                    </td>
                    <td class="text-center"><?php echo e(\Carbon\Carbon::parse($row->created_at)->format('d M Y')); ?></td>
                    <td class="text-center">
                        <?php if($row->type === 'rider'): ?>
                            <a href="<?php echo e(route('admin.riders.show', $row->owner_id)); ?>" class="icon-btn view-btn" title="View Rider">
                                <i class="fa-solid fa-eye"></i>
                            </a>
                        <?php else: ?>
                            <a href="<?php echo e(route('admin.users.show', ['type'=>$row->type,'id'=>$row->owner_id])); ?>" class="icon-btn view-btn" title="View User">
                                <i class="fa-solid fa-eye"></i>
                            </a>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="4" class="text-muted py-4 text-center">No pending bank approvals</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>  
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Freshora\Laravel\buildours\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>