

<?php $__env->startSection('title', ucfirst($type) . ' Management'); ?>

<?php $__env->startSection('styles'); ?>
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet">

<style>
/* ===============================
   DATATABLE HEADER (FIXED)
=============================== */
.dataTables_wrapper table.dataTable thead th {
    background: linear-gradient(to bottom, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: .05em;
    text-align: center;
    border: none !important;
}

.dataTables_wrapper table.dataTable thead tr {
    background: none !important;
}

/* Rounded header */
.dataTables_wrapper table.dataTable thead th:first-child {
    border-top-left-radius: 12px;
}
.dataTables_wrapper table.dataTable thead th:last-child {
    border-top-right-radius: 12px;
}

/* Space below search bar */
.dataTables_wrapper .dataTables_filter {
    margin-bottom: 16px;
}

/* Space above table */
.dataTables_wrapper table.dataTable {
    margin-top: 12px !important;
}

@media (max-width: 768px) {
    .dataTables_wrapper {
        overflow-x: auto !important;
        -webkit-overflow-scrolling: touch;
    }

    .table-responsive {
        overflow-x: auto !important;
    }

    table.dataTable {
        min-width: 900px;
    }
}

/* ===============================
   TABLE BODY
=============================== */
table.dataTable tbody td {
    font-size: 14px;
    color: #374151;
    border-top: 1px solid #eef2f6;
    text-align: center;
}

/* Zebra rows */
table.dataTable tbody tr:nth-child(odd) {
    background-color: #f8fbff;
}
table.dataTable tbody tr:nth-child(even) {
    background-color: #ffffff;
}

/* ===============================
   ANIMATED ROW HOVER (PRO)
=============================== */
table.dataTable tbody tr {
    transition: all 0.25s ease;
}

table.dataTable tbody tr:hover {
    background-color: #e9f6ff !important;
    box-shadow: 0 6px 18px rgba(41,178,246,.15);
    z-index: 2;
    position: relative;
}

.dataTables_wrapper {
    overflow: hidden;
}

.table-responsive {
    overflow-x: hidden;
}

/* ===============================
   STATUS BADGES
=============================== */
.status {
    padding: 6px 16px;
    font-size: 12px;
    font-weight: 600;
    border-radius: 30px;
    display: inline-block;
}

.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-pending { background: #fff5e5; color: #d48806; }
.status-rejected { background: #fdecea; color: #c62828; }

/* ===============================
   ACTION BUTTONS
=============================== */
.action-btn {
    border: none;
    background: none;
    font-size: 20px;
    margin: 0 8px;
    cursor: pointer;
    transition: transform .2s;
}

.action-btn:hover {
    transform: scale(1.2);
}

.action-approve { color: #22c55e; }
.action-reject { color: #ef4444; }

/* ===============================
   DATATABLE CONTROLS
=============================== */
.dataTables_filter input {
    border-radius: 20px;
    padding: 6px 14px;
    border: 1px solid #d1d5db;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    border: none !important;
    border-radius: 8px !important;
    box-shadow: 0 4px 10px rgba(41,178,246,.35);
}
/* ===============================
   UNIVERSAL ACTION ICON BUTTONS
=============================== */
.icon-btn {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    border: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    background: #f1f5f9;
    color: #334155;
    cursor: pointer;
    transition: all .2s ease;
    text-decoration: none;
    margin: 0 2px;
}

.icon-btn i {
    font-size: 15px;
}

/* View */
.view-btn {
    color: #0dcaf0;
}
.view-btn:hover {
    background: rgba(13,202,240,.15);
    transform: translateY(-2px);
}

/* Approve */
.approve-btn {
    color: #22c55e;
}
.approve-btn:hover {
    background: rgba(34,197,94,.15);
    transform: translateY(-2px);
}

/* Reject */
.reject-btn {
    color: #ef4444;
}
.reject-btn:hover {
    background: rgba(239,68,68,.15);
    transform: translateY(-2px);
}

/* ===============================
   MODALS
=============================== */
.modal-header {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
}

.modal-footer .btn {
    border-radius: 20px;
}

.modal-dialog {
    justify-content: center !important;
}


</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold"><?php echo e(ucfirst($type)); ?> Management</h3>
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-outline-secondary btn-sm">
            ← Dashboard
        </a>
    </div>

    <div class="card border-0 shadow-lg rounded-4">
        <div class="card-body">
            <div class="table-responsive">
                <table id="common-table" class="display w-100">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Owner Name</th>
                            <th><?php echo e($type === 'warehouse' ? 'Warehouse Name' : 'Store Name'); ?></th>
                            <th>Email</th>
                            <th>Mobile</th>
                            <th>City</th>
                            <th>Status</th>
                            <th>Orders</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="text-center">
                                <?php echo e($loop->iteration); ?>

                            </td>



                            <td style="text-align: left;" class="fw-semibold">
                                <?php echo e($item->owner_name); ?>

                            </td>

                            <td style="text-align: left;" class="fw-semibold">
                                <?php echo e($type === 'warehouse' ? $item->warehouse_name : $item->store_name); ?>

                            </td>

                            <td style="text-align: left;"><?php echo e($item->email); ?></td>
                            <td><?php echo e($item->mobile_number); ?></td>
                            <td><?php echo e($item->city); ?></td>

                            <td>
                                <?php if($item->status === 'active'): ?>
                                    <span class="status status-active">Active</span>
                                <?php elseif($item->status === 'pending_admin'): ?>
                                    <span class="status status-pending">Pending</span>
                                <?php else: ?>
                                    <span class="status status-rejected">Rejected</span>
                                <?php endif; ?>
                            </td>

                            <td class="text-center">
                                <?php if($type === 'warehouse'): ?>
                                    <a href="<?php echo e(route('admin.orders.index', ['warehouse_id' => $item->id])); ?>"
                                    class="icon-btn view-btn"
                                    title="View Orders">
                                        <i class="fa-solid fa-boxes-stacked"></i>
                                    </a>

                                <?php elseif($type === 'store'): ?>
                                    <div class="d-flex justify-content-center">
                                        <a href="<?php echo e(route('admin.orders.index', ['store_id' => $item->id, 'type' => 'sales'])); ?>"
                                        class="icon-btn approve-btn"
                                        title="Sales Orders">
                                            <i class="fa-solid fa-arrow-up-right-dots"></i>
                                        </a>

                                        <a href="<?php echo e(route('admin.orders.index', ['store_id' => $item->id, 'type' => 'purchase'])); ?>"
                                        class="icon-btn reject-btn"
                                        title="Purchase Orders">
                                            <i class="fa-solid fa-arrow-down-wide-short"></i>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </td>

                            <td class="text-center">
                                <a href="<?php echo e(route('admin.users.show', [$type, $item->id])); ?>"
                                class="icon-btn view-btn"
                                title="View Details">
                                    <i class="fa-solid fa-eye"></i>
                                </a>

                                <?php if($item->status === 'pending_admin'): ?>
                                    <button class="icon-btn approve-btn"
                                            data-bs-toggle="modal"
                                            data-bs-target="#approveModal"
                                            data-id="<?php echo e($item->id); ?>"
                                            title="Approve">
                                        <i class="fa-solid fa-check"></i>
                                    </button>

                                    <button class="icon-btn reject-btn"
                                            data-bs-toggle="modal"
                                            data-bs-target="#rejectModal"
                                            data-id="<?php echo e($item->id); ?>"
                                            title="Reject">
                                        <i class="fa-solid fa-xmark"></i>
                                    </button>
                                <?php endif; ?>
                            </td>

                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>
            </div>
        </div>
    </div>

</div>


<div class="modal fade" id="approveModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="approveForm">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Approve <?php echo e(ucfirst($type)); ?></h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <p>Are you sure you want to approve this <?php echo e($type); ?>?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success px-4">Approve</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="rejectForm">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reject <?php echo e(ucfirst($type)); ?></h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <p>Are you sure you want to reject this <?php echo e($type); ?>?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-danger px-4">Reject</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
$(function () {

    $('#common-table').DataTable({
        pageLength: 10,
        ordering: true,
        order: [],
        columnDefs: [{ orderable: false, targets: [0, 8] }]
    });

    $('#approveModal').on('show.bs.modal', function (e) {
        let id = $(e.relatedTarget).data('id');
        let url = "<?php echo e(route('admin.users.approve', ['type' => $type, 'id' => ':id'])); ?>";
        $('#approveForm').attr('action', url.replace(':id', id));
    });

    $('#rejectModal').on('show.bs.modal', function (e) {
        let id = $(e.relatedTarget).data('id');
        let url = "<?php echo e(route('admin.users.reject', ['type' => $type, 'id' => ':id'])); ?>";
        $('#rejectForm').attr('action', url.replace(':id', id));
    });

});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Freshora\Laravel\buildours\resources\views/admin/users/index.blade.php ENDPATH**/ ?>