<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Apigateway;

class ApigatewayApiConfigGrpcServiceDefinition extends \Google\Collection
{
  protected $collection_key = 'source';
  protected $fileDescriptorSetType = ApigatewayApiConfigFile::class;
  protected $fileDescriptorSetDataType = '';
  protected $sourceType = ApigatewayApiConfigFile::class;
  protected $sourceDataType = 'array';

  /**
   * Input only. File descriptor set, generated by protoc. To generate, use
   * protoc with imports and source info included. For an example test.proto
   * file, the following command would put the value in a new file named out.pb.
   * $ protoc --include_imports --include_source_info test.proto -o out.pb
   *
   * @param ApigatewayApiConfigFile $fileDescriptorSet
   */
  public function setFileDescriptorSet(ApigatewayApiConfigFile $fileDescriptorSet)
  {
    $this->fileDescriptorSet = $fileDescriptorSet;
  }
  /**
   * @return ApigatewayApiConfigFile
   */
  public function getFileDescriptorSet()
  {
    return $this->fileDescriptorSet;
  }
  /**
   * Optional. Uncompiled proto files associated with the descriptor set, used
   * for display purposes (server-side compilation is not supported). These
   * should match the inputs to 'protoc' command used to generate
   * file_descriptor_set.
   *
   * @param ApigatewayApiConfigFile[] $source
   */
  public function setSource($source)
  {
    $this->source = $source;
  }
  /**
   * @return ApigatewayApiConfigFile[]
   */
  public function getSource()
  {
    return $this->source;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ApigatewayApiConfigGrpcServiceDefinition::class, 'Google_Service_Apigateway_ApigatewayApiConfigGrpcServiceDefinition');
