<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Apigee;

class GoogleCloudApigeeV1KeystoreConfig extends \Google\Collection
{
  protected $collection_key = 'aliases';
  protected $aliasesType = GoogleCloudApigeeV1AliasRevisionConfig::class;
  protected $aliasesDataType = 'array';
  /**
   * Resource name in the following format:
   * `organizations/{org}/environments/{env}/keystores/{keystore}`
   *
   * @var string
   */
  public $name;

  /**
   * Aliases in the keystore.
   *
   * @param GoogleCloudApigeeV1AliasRevisionConfig[] $aliases
   */
  public function setAliases($aliases)
  {
    $this->aliases = $aliases;
  }
  /**
   * @return GoogleCloudApigeeV1AliasRevisionConfig[]
   */
  public function getAliases()
  {
    return $this->aliases;
  }
  /**
   * Resource name in the following format:
   * `organizations/{org}/environments/{env}/keystores/{keystore}`
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApigeeV1KeystoreConfig::class, 'Google_Service_Apigee_GoogleCloudApigeeV1KeystoreConfig');
