<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Appengine;

class ManualScaling extends \Google\Model
{
  /**
   * Number of instances to assign to the service at the start. This number can
   * later be altered by using the Modules API
   * (https://cloud.google.com/appengine/docs/python/modules/functions)
   * set_num_instances() function.
   *
   * @var int
   */
  public $instances;

  /**
   * Number of instances to assign to the service at the start. This number can
   * later be altered by using the Modules API
   * (https://cloud.google.com/appengine/docs/python/modules/functions)
   * set_num_instances() function.
   *
   * @param int $instances
   */
  public function setInstances($instances)
  {
    $this->instances = $instances;
  }
  /**
   * @return int
   */
  public function getInstances()
  {
    return $this->instances;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ManualScaling::class, 'Google_Service_Appengine_ManualScaling');
