<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ChromePolicy;

class GoogleChromePolicyVersionsV1AdditionalTargetKeyName extends \Google\Model
{
  /**
   * Key name.
   *
   * @var string
   */
  public $key;
  /**
   * Key description.
   *
   * @var string
   */
  public $keyDescription;

  /**
   * Key name.
   *
   * @param string $key
   */
  public function setKey($key)
  {
    $this->key = $key;
  }
  /**
   * @return string
   */
  public function getKey()
  {
    return $this->key;
  }
  /**
   * Key description.
   *
   * @param string $keyDescription
   */
  public function setKeyDescription($keyDescription)
  {
    $this->keyDescription = $keyDescription;
  }
  /**
   * @return string
   */
  public function getKeyDescription()
  {
    return $this->keyDescription;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleChromePolicyVersionsV1AdditionalTargetKeyName::class, 'Google_Service_ChromePolicy_GoogleChromePolicyVersionsV1AdditionalTargetKeyName');
