<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudTasks;

class CreateTaskRequest extends \Google\Model
{
  /**
   * Unspecified. Defaults to BASIC.
   */
  public const RESPONSE_VIEW_VIEW_UNSPECIFIED = 'VIEW_UNSPECIFIED';
  /**
   * The basic view omits fields which can be large or can contain sensitive
   * data. This view does not include the body in AppEngineHttpRequest. Bodies
   * are desirable to return only when needed, because they can be large and
   * because of the sensitivity of the data that you choose to store in it.
   */
  public const RESPONSE_VIEW_BASIC = 'BASIC';
  /**
   * All information is returned. Authorization for FULL requires
   * `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
   * permission on the Queue resource.
   */
  public const RESPONSE_VIEW_FULL = 'FULL';
  /**
   * The response_view specifies which subset of the Task will be returned. By
   * default response_view is BASIC; not all information is retrieved by default
   * because some data, such as payloads, might be desirable to return only when
   * needed because of its large size or because of the sensitivity of data that
   * it contains. Authorization for FULL requires `cloudtasks.tasks.fullView`
   * [Google IAM](https://cloud.google.com/iam/) permission on the Task
   * resource.
   *
   * @var string
   */
  public $responseView;
  protected $taskType = Task::class;
  protected $taskDataType = '';

  /**
   * The response_view specifies which subset of the Task will be returned. By
   * default response_view is BASIC; not all information is retrieved by default
   * because some data, such as payloads, might be desirable to return only when
   * needed because of its large size or because of the sensitivity of data that
   * it contains. Authorization for FULL requires `cloudtasks.tasks.fullView`
   * [Google IAM](https://cloud.google.com/iam/) permission on the Task
   * resource.
   *
   * Accepted values: VIEW_UNSPECIFIED, BASIC, FULL
   *
   * @param self::RESPONSE_VIEW_* $responseView
   */
  public function setResponseView($responseView)
  {
    $this->responseView = $responseView;
  }
  /**
   * @return self::RESPONSE_VIEW_*
   */
  public function getResponseView()
  {
    return $this->responseView;
  }
  /**
   * Required. The task to add. Task names have the following format:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
   * The user can optionally specify a task name. If a name is not specified
   * then the system will generate a random unique task id, which will be set in
   * the task returned in the response. If schedule_time is not set or is in the
   * past then Cloud Tasks will set it to the current time. Task De-duplication:
   * Explicitly specifying a task ID enables task de-duplication. If a task's ID
   * is identical to that of an existing task or a task that was deleted or
   * executed recently then the call will fail with ALREADY_EXISTS. The IDs of
   * deleted tasks are not immediately available for reuse. It can take up to 24
   * hours (or 9 days if the task's queue was created using a queue.yaml or
   * queue.xml) for the task ID to be released and made available again. Because
   * there is an extra lookup cost to identify duplicate task names, these
   * CreateTask calls have significantly increased latency. Using hashed strings
   * for the task id or for the prefix of the task id is recommended. Choosing
   * task ids that are sequential or have sequential prefixes, for example using
   * a timestamp, causes an increase in latency and error rates in all task
   * commands. The infrastructure relies on an approximately uniform
   * distribution of task ids to store and serve tasks efficiently.
   *
   * @param Task $task
   */
  public function setTask(Task $task)
  {
    $this->task = $task;
  }
  /**
   * @return Task
   */
  public function getTask()
  {
    return $this->task;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CreateTaskRequest::class, 'Google_Service_CloudTasks_CreateTaskRequest');
