<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DisplayVideo;

class AudioVideoOffset extends \Google\Model
{
  /**
   * Optional. The offset in percentage of the audio or video duration.
   *
   * @var string
   */
  public $percentage;
  /**
   * Optional. The offset in seconds from the start of the audio or video.
   *
   * @var string
   */
  public $seconds;

  /**
   * Optional. The offset in percentage of the audio or video duration.
   *
   * @param string $percentage
   */
  public function setPercentage($percentage)
  {
    $this->percentage = $percentage;
  }
  /**
   * @return string
   */
  public function getPercentage()
  {
    return $this->percentage;
  }
  /**
   * Optional. The offset in seconds from the start of the audio or video.
   *
   * @param string $seconds
   */
  public function setSeconds($seconds)
  {
    $this->seconds = $seconds;
  }
  /**
   * @return string
   */
  public function getSeconds()
  {
    return $this->seconds;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AudioVideoOffset::class, 'Google_Service_DisplayVideo_AudioVideoOffset');
