<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Firestore;

class Stage extends \Google\Collection
{
  protected $collection_key = 'args';
  protected $argsType = Value::class;
  protected $argsDataType = 'array';
  /**
   * Required. The name of the stage to evaluate. **Requires:** * must be in
   * snake case (lower case with underscore separator).
   *
   * @var string
   */
  public $name;
  protected $optionsType = Value::class;
  protected $optionsDataType = 'map';

  /**
   * Optional. Ordered list of arguments the given stage expects.
   *
   * @param Value[] $args
   */
  public function setArgs($args)
  {
    $this->args = $args;
  }
  /**
   * @return Value[]
   */
  public function getArgs()
  {
    return $this->args;
  }
  /**
   * Required. The name of the stage to evaluate. **Requires:** * must be in
   * snake case (lower case with underscore separator).
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Optional. Optional named arguments that certain functions may support.
   *
   * @param Value[] $options
   */
  public function setOptions($options)
  {
    $this->options = $options;
  }
  /**
   * @return Value[]
   */
  public function getOptions()
  {
    return $this->options;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Stage::class, 'Google_Service_Firestore_Stage');
